/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.initandlookup;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.initandlookup.StrictKernel;
import org.hibernate.search.test.util.GatedLuceneBackend;
import org.hibernate.stat.Statistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictSecondLCAndPCLookupTest
extends SearchTestCase {
    public void testStaleCacheWithAsyncIndexer() {
        Session session = this.openSession();
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.clear();
        statistics.setStatisticsEnabled(true);
        this.setData(session, statistics);
        GatedLuceneBackend.open.set(false);
        Transaction tx = session.beginTransaction();
        List list = session.createCriteria(StrictKernel.class).list();
        Assertions.assertThat((List)list).hasSize(2);
        session.delete(list.get(0));
        tx.commit();
        session.clear();
        GatedLuceneBackend.open.set(true);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery allKernelsQuery = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]).initializeObjectsWith(ObjectLookupMethod.SECOND_LEVEL_CACHE, DatabaseRetrievalMethod.QUERY);
        Assertions.assertThat((List)allKernelsQuery.list()).hasSize(1);
    }

    private void setData(Session session, Statistics statistics) {
        Transaction transaction = session.beginTransaction();
        StrictKernel k = new StrictKernel();
        k.setCodeName("coconut");
        k.setProduct("Polgeiser");
        session.persist((Object)k);
        StrictKernel k2 = new StrictKernel();
        k2.setCodeName("ballpark");
        k2.setProduct("Polgeiser");
        session.persist((Object)k2);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        session.get(StrictKernel.class, (Serializable)k.getId());
        session.get(StrictKernel.class, (Serializable)k2.getId());
        transaction.commit();
        Assertions.assertThat((long)statistics.getSecondLevelCachePutCount()).isEqualTo(2L);
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.cache.use_second_level_cache", "true");
        cfg.setProperty("hibernate.search.default.worker.backend", GatedLuceneBackend.class.getName());
        cfg.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.HashtableCacheProvider");
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{StrictKernel.class};
    }
}

