/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.session;

import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.impl.FullTextSessionImpl;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.session.Categorie;
import org.hibernate.search.test.session.Domain;
import org.hibernate.search.test.session.Email;
import org.hibernate.search.test.session.Entite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MassIndexTest
extends SearchTestCase {
    public void testBatchSize() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        int loop = 14;
        for (int i = 0; i < loop; ++i) {
            Statement statmt = s.connection().createStatement();
            statmt.executeUpdate("insert into Domain(id, name) values( + " + (i + 1) + ", 'sponge" + i + "')");
            statmt.executeUpdate("insert into Email(id, title, body, header, domain_id) values( + " + (i + 1) + ", 'Bob Sponge', 'Meet the guys who create the software', 'nope', " + (i + 1) + ")");
            statmt.close();
        }
        tx.commit();
        s.close();
        s = new FullTextSessionImpl(this.openSession());
        tx = s.beginTransaction();
        ScrollableResults results = s.createCriteria(Email.class).scroll(ScrollMode.FORWARD_ONLY);
        int index = 0;
        while (results.next()) {
            s.index(results.get(0));
            if (++index % 5 != 0) continue;
            s.clear();
        }
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(MassIndexTest.getTargetLuceneVersion(), "id", SearchTestCase.stopAnalyzer);
        List result = s.createFullTextQuery(parser.parse("body:create"), new Class[0]).list();
        MassIndexTest.assertEquals((int)14, (int)result.size());
        for (Object object : result) {
            s.delete(object);
        }
        tx.commit();
        s.close();
    }

    public void testTransactional() throws Exception {
        int i;
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        int loop = 4;
        for (int i2 = 0; i2 < loop; ++i2) {
            Email email = new Email();
            email.setId((long)i2 + 1L);
            email.setTitle("JBoss World Berlin");
            email.setBody("Meet the guys who wrote the software");
            s.persist((Object)email);
        }
        tx.commit();
        s.close();
        s = new FullTextSessionImpl(this.openSession());
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(MassIndexTest.getTargetLuceneVersion(), "id", SearchTestCase.stopAnalyzer);
        List result = s.createFullTextQuery(parser.parse("body:create"), new Class[0]).list();
        MassIndexTest.assertEquals((int)0, (int)result.size());
        tx.commit();
        s.close();
        s = new FullTextSessionImpl(this.openSession());
        s.getTransaction().begin();
        Statement stmt = s.connection().createStatement();
        stmt.executeUpdate("update Email set body='Meet the guys who write the software'");
        stmt.close();
        stmt = s.connection().createStatement();
        stmt.executeUpdate("insert into Email(id, title, body, header) values( + " + (loop + 1) + ", 'Bob Sponge', 'Meet the guys who create the software', 'nope')");
        stmt.close();
        s.getTransaction().commit();
        s.close();
        s = new FullTextSessionImpl(this.openSession());
        tx = s.beginTransaction();
        parser = new QueryParser(MassIndexTest.getTargetLuceneVersion(), "id", SearchTestCase.stopAnalyzer);
        result = s.createFullTextQuery(parser.parse("body:write"), new Class[0]).list();
        MassIndexTest.assertEquals((int)0, (int)result.size());
        result = s.createCriteria(Email.class).list();
        for (i = 0; i < loop / 2; ++i) {
            s.index(result.get(i));
        }
        tx.commit();
        s.index(result.get(loop / 2));
        tx = s.beginTransaction();
        for (i = loop / 2 + 1; i < loop; ++i) {
            s.index(result.get(i));
        }
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        Email email = (Email)s.get(Email.class, (Serializable)Long.valueOf(loop + 1));
        s.index((Object)email);
        tx.commit();
        s.close();
        s = new FullTextSessionImpl(this.openSession());
        tx = s.beginTransaction();
        result = s.createFullTextQuery(parser.parse("body:create"), new Class[0]).list();
        MassIndexTest.assertEquals((int)1, (int)result.size());
        tx.commit();
        s.close();
    }

    public void testLazyLoading() throws Exception {
        Categorie cat = new Categorie("Livre");
        Entite ent = new Entite("Le temple des songes", cat);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cat);
        s.persist((Object)ent);
        tx.commit();
        s.close();
        s = this.getSessionWithAutoCommit();
        FullTextSession session = Search.getFullTextSession((Session)s);
        TermQuery luceneQuery = new TermQuery(new Term("categorie.nom", "livre"));
        List result = session.createFullTextQuery((Query)luceneQuery, new Class[]{Entite.class}).list();
        MassIndexTest.assertEquals((int)1, (int)result.size());
        s.close();
        s = this.getSessionWithAutoCommit();
        ent = (Entite)s.get(Entite.class, (Serializable)ent.getId());
        session = Search.getFullTextSession((Session)s);
        session.index((Object)ent);
        s.close();
        s = this.getSessionWithAutoCommit();
        session = Search.getFullTextSession((Session)s);
        luceneQuery = new TermQuery(new Term("categorie.nom", "livre"));
        result = session.createFullTextQuery((Query)luceneQuery, new Class[]{Entite.class}).list();
        MassIndexTest.assertEquals((String)"test lazy loading and indexing", (int)1, (int)result.size());
        s.close();
        s = this.getSessionWithAutoCommit();
        Iterator it = s.createQuery("from Entite where id = :id").setParameter("id", (Object)ent.getId()).iterate();
        session = Search.getFullTextSession((Session)s);
        while (it.hasNext()) {
            ent = (Entite)it.next();
            session.index((Object)ent);
        }
        s.close();
        s = this.getSessionWithAutoCommit();
        session = Search.getFullTextSession((Session)s);
        luceneQuery = new TermQuery(new Term("categorie.nom", "livre"));
        result = session.createFullTextQuery((Query)luceneQuery, new Class[]{Entite.class}).list();
        MassIndexTest.assertEquals((String)"test lazy loading and indexing", (int)1, (int)result.size());
        s.close();
    }

    private Session getSessionWithAutoCommit() throws SQLException {
        Session s = this.openSession();
        s.connection().setAutoCommit(true);
        return s;
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.worker.batch_size", "5");
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class, Entite.class, Categorie.class, Domain.class};
    }
}

