/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;

public final class FloatFieldLoadingStrategy
implements FieldLoadingStrategy {
    private final String fieldName;
    private float[] currentCache;

    public FloatFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    public void loadNewCacheValues(IndexReader reader) throws IOException {
        this.currentCache = FieldCache.DEFAULT.getFloats(reader, this.fieldName);
    }

    public Float collect(int relativeDocId) {
        return Float.valueOf(this.currentCache[relativeDocId]);
    }
}

