/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextObjectsInitializer
implements ObjectsInitializer {
    private static final Logger log = LoggerFactory.make();
    private final ObjectsInitializer delegate;

    public PersistenceContextObjectsInitializer(ObjectsInitializer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, Criteria criteria, Class<?> entityType, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager, Session session) {
        int maxResults = entityInfos.length;
        if (maxResults == 0) {
            log.trace("No object to initialize", (Object)maxResults);
            return;
        }
        SessionImplementor sessionImplementor = (SessionImplementor)session;
        String entityName = session.getSessionFactory().getClassMetadata(entityType).getEntityName();
        EntityPersister persister = sessionImplementor.getFactory().getEntityPersister(entityName);
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        ArrayList<EntityInfo> remainingEntityInfos = new ArrayList<EntityInfo>(entityInfos.length);
        for (EntityInfo entityInfo : entityInfos) {
            if (ObjectLoaderHelper.areDocIdAndEntityIdIdentical(entityInfo, session)) {
                EntityKey entityKey = new EntityKey(entityInfo.getId(), persister, session.getEntityMode());
                boolean isInitialized = persistenceContext.containsEntity(entityKey);
                if (isInitialized) continue;
                remainingEntityInfos.add(entityInfo);
                continue;
            }
            remainingEntityInfos.add(entityInfo);
        }
        int remainingSize = remainingEntityInfos.size();
        log.trace("Initialized {} objects out of {} in the persistence context", (Object)(maxResults - remainingSize), (Object)maxResults);
        if (remainingSize > 0) {
            this.delegate.initializeObjects(remainingEntityInfos.toArray(new EntityInfo[remainingSize]), criteria, entityType, searchFactoryImplementor, timeoutManager, session);
        }
    }
}

