/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.annotationfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationProxy;

public class AnnotationFactory {
    public static <T extends Annotation> T create(AnnotationDescriptor<T> descriptor) {
        Class<?> proxyClass = Proxy.getProxyClass(ReflectionHelper.getClassLoaderFromClass(descriptor.type()), descriptor.type());
        AnnotationProxy handler = new AnnotationProxy(descriptor);
        try {
            return (T)AnnotationFactory.getProxyInstance(proxyClass, handler);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T extends Annotation> T getProxyInstance(Class<T> proxyClass, InvocationHandler handler) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> constructor = ReflectionHelper.getDeclaredConstructor(proxyClass, InvocationHandler.class);
        return (T)((Annotation)ReflectionHelper.newConstructorInstance(constructor, handler));
    }
}

