/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import org.jaitools.numeric.NumberOperations;
import org.jaitools.numeric.RangeExtendedComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range<T extends Number> {
    public static final int NEG_INF = -1;
    public static final int INF = 1;
    static final int FINITE = 0;
    private static final int NAN = -9999;
    private T minValue;
    private boolean minIncluded;
    private boolean minOpen;
    private int minType;
    private T maxValue;
    private boolean maxIncluded;
    private boolean maxOpen;
    private int maxType;
    private boolean isPoint;

    public static <T extends Number> Range<T> create(T minValue, boolean minIncluded, T maxValue, boolean maxIncluded) {
        return new Range<T>(minValue, minIncluded, maxValue, maxIncluded);
    }

    public static <T extends Number> Range<T> create(T value, int ... inf) {
        return new Range<T>(value, inf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Range(T minValue, boolean minIncluded, T maxValue, boolean maxIncluded) {
        if (minValue != null && maxValue != null && ((Comparable)minValue).compareTo(maxValue) > 0) {
            throw new IllegalArgumentException("minValue greater than maxValue");
        }
        this.minType = 0;
        if (minValue == null) {
            this.minType = -1;
        } else if (minValue instanceof Double) {
            if (Double.isInfinite(((Number)minValue).doubleValue())) {
                this.minType = Double.compare(((Number)minValue).doubleValue(), Double.POSITIVE_INFINITY) == 0 ? 1 : -1;
            } else if (Double.isNaN(((Number)minValue).doubleValue())) {
                this.minType = -1;
            }
        } else if (minValue instanceof Float) {
            if (Float.isInfinite(((Number)minValue).floatValue())) {
                this.minType = Float.compare(((Number)minValue).floatValue(), Float.POSITIVE_INFINITY) == 0 ? 1 : -1;
            } else if (Float.isNaN(((Number)minValue).floatValue())) {
                this.minType = -1;
            }
        }
        if (this.minType == 0) {
            this.minValue = minValue;
            this.minOpen = false;
            this.minIncluded = minIncluded;
        } else {
            this.minValue = null;
            this.minOpen = true;
            this.minIncluded = false;
        }
        this.maxType = 0;
        if (maxValue == null) {
            this.maxType = 1;
        } else if (maxValue instanceof Double) {
            if (Double.isInfinite(((Number)maxValue).doubleValue())) {
                this.maxType = Double.compare(((Number)maxValue).doubleValue(), Double.POSITIVE_INFINITY) == 0 ? 1 : -1;
            } else if (Double.isNaN(((Number)maxValue).doubleValue())) {
                this.maxType = 1;
            }
        } else if (maxValue instanceof Float) {
            if (Float.isInfinite(((Number)maxValue).floatValue())) {
                this.maxType = Float.compare(((Number)maxValue).floatValue(), Float.POSITIVE_INFINITY) == 0 ? 1 : -1;
            } else if (Float.isNaN(((Number)maxValue).floatValue())) {
                this.maxType = 1;
            }
        }
        if (this.maxType == 0) {
            this.maxValue = maxValue;
            this.maxOpen = false;
            this.maxIncluded = maxIncluded;
        } else {
            this.maxValue = null;
            this.maxOpen = true;
            this.maxIncluded = false;
        }
        if (this.minType == 0 && this.maxType == 0) {
            if (minValue != maxValue) return;
            if (!minIncluded || !maxIncluded) throw new IllegalArgumentException("point range created with the interval constructor must have min and max endpoints included");
            this.isPoint = true;
            return;
        } else if (this.minType == this.maxType) {
            this.isPoint = true;
            return;
        } else {
            if (this.minType != 1 || this.maxType != -1) return;
            throw new IllegalArgumentException("invalid to have min endpoint at Inf  and max endpoint at Neg Inf");
        }
    }

    public Range(T value, int ... inf) {
        this.isPoint = true;
        int bound = 0;
        if (value == null) {
            if (inf == null || inf.length < 1 || inf[0] != 1 && inf[0] != -1) {
                throw new IllegalArgumentException("one of BOUND_INF or BOUND_NEG_INF must be provided with a null value");
            }
            bound = inf[0];
        } else if (value instanceof Double) {
            if (Double.isInfinite(((Number)value).doubleValue())) {
                bound = Double.compare(((Number)value).doubleValue(), Double.POSITIVE_INFINITY) == 0 ? 1 : -1;
            } else if (Double.isNaN(((Number)value).doubleValue())) {
                bound = -9999;
            }
        } else if (value instanceof Float) {
            if (Float.isInfinite(((Number)value).floatValue())) {
                bound = Float.compare(((Number)value).floatValue(), Float.POSITIVE_INFINITY) == 0 ? 1 : -1;
            } else if (Float.isNaN(((Number)value).floatValue())) {
                bound = -9999;
            }
        }
        if (bound == 0) {
            this.minValue = value;
            this.maxValue = this.minValue;
            this.minType = 0;
            this.maxType = 0;
            this.minOpen = false;
            this.maxOpen = false;
            this.minIncluded = true;
            this.maxIncluded = true;
        } else {
            this.minValue = null;
            this.maxValue = null;
            this.maxType = this.minType = bound;
            this.maxOpen = true;
            this.minOpen = true;
            this.minIncluded = false;
            this.maxIncluded = false;
        }
    }

    public Range(Range<T> other) {
        this.minValue = other.minValue;
        this.minIncluded = other.minIncluded;
        this.minOpen = other.minOpen;
        this.minType = other.minType;
        this.maxValue = other.maxValue;
        this.maxIncluded = other.maxIncluded;
        this.maxOpen = other.maxOpen;
        this.maxType = other.maxType;
        this.isPoint = other.isPoint;
    }

    public boolean isPoint() {
        return this.isPoint;
    }

    public T getMin() {
        return this.minValue;
    }

    public boolean isMinInf() {
        return this.minType == 1;
    }

    public boolean isMinNegInf() {
        return this.minType == -1;
    }

    public T getMax() {
        return this.maxValue;
    }

    public boolean isMaxInf() {
        return this.maxType == 1;
    }

    public boolean isMaxNegInf() {
        return this.maxType == -1;
    }

    public boolean isMinIncluded() {
        return this.minIncluded;
    }

    public boolean isMaxIncluded() {
        return this.maxIncluded;
    }

    public boolean isMinOpen() {
        return this.minOpen;
    }

    public boolean isMinClosed() {
        return !this.minOpen;
    }

    public boolean isMaxOpen() {
        return this.maxOpen;
    }

    public boolean isMaxClosed() {
        return !this.maxOpen;
    }

    public boolean contains(T value) {
        int comp;
        if (value == null) {
            throw new UnsupportedOperationException("null values are not supported");
        }
        if (this.isPoint) {
            if (this.minType == 0) {
                return NumberOperations.compare(this.minValue, value) == 0;
            }
            if (this.minType == -9999) {
                if (value instanceof Double) {
                    return Double.isNaN(((Number)value).doubleValue());
                }
                return Float.isNaN(((Number)value).floatValue());
            }
            return false;
        }
        if (value instanceof Double && Double.isNaN(((Number)value).doubleValue()) || value instanceof Float && Float.isNaN(((Number)value).floatValue())) {
            return false;
        }
        if (this.minValue != null && ((comp = NumberOperations.compare(value, this.minValue)) < 0 || !this.minIncluded && comp == 0)) {
            return false;
        }
        return this.maxValue == null || (comp = NumberOperations.compare(value, this.maxValue)) <= 0 && (this.maxIncluded || comp != 0);
    }

    public boolean intersects(Range<T> other) {
        RangeExtendedComparator.Result comp = this.compareTo(other);
        return RangeExtendedComparator.isIntersection(comp);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.isPoint != other.isPoint) {
            return false;
        }
        if (!(this.minValue == other.minValue || this.minValue != null && this.minValue.equals(other.minValue))) {
            return false;
        }
        if (this.minIncluded != other.minIncluded) {
            return false;
        }
        if (!(this.maxValue == other.maxValue || this.maxValue != null && this.maxValue.equals(other.maxValue))) {
            return false;
        }
        return this.maxIncluded == other.maxIncluded;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.minValue != null ? this.minValue.hashCode() : 0);
        hash = 11 * hash + (this.minIncluded ? 1 : 0);
        hash = 11 * hash + (this.maxValue != null ? this.maxValue.hashCode() : 0);
        hash = 11 * hash + (this.maxIncluded ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isMinClosed()) {
            sb.append(this.isMinIncluded() ? (char)'[' : '(');
            sb.append(this.getMin());
        } else if (this.isPoint()) {
            sb.append(this.isMinInf() ? "(Inf" : "(-Inf");
        } else {
            sb.append("(-Inf");
        }
        if (this.isPoint()) {
            sb.append(this.isMinIncluded() ? (char)']' : ')');
        } else {
            sb.append(", ");
            if (this.isMaxClosed()) {
                sb.append(this.getMax());
                sb.append(this.isMaxIncluded() ? (char)']' : ')');
            } else {
                sb.append("Inf)");
            }
        }
        return sb.toString();
    }

    RangeExtendedComparator.Result compareTo(Range<T> other) {
        RangeExtendedComparator<T> rc = new RangeExtendedComparator<T>();
        return rc.compare(this, other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INCLUDE,
        EXCLUDE,
        UNDEFINED;

    }
}

