/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Command;
import hudson.remoting.Future;
import hudson.remoting.RequestAbortedException;
import hudson.remoting.Response;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Request<RSP extends Serializable, EXC extends Throwable>
extends Command {
    private final int id;
    private int lastIoId;
    private volatile Response<RSP, EXC> response;
    transient long startTime;
    volatile transient java.util.concurrent.Future<?> future;
    volatile transient int responseIoId;
    @Deprecated
    volatile transient java.util.concurrent.Future<?> lastIo;
    private static int nextId = 0;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Request.class.getName());
    static boolean chainCause = Boolean.getBoolean(Request.class.getName() + ".chainCause");
    @Deprecated
    static ThreadLocal<Request> CURRENT = new ThreadLocal();

    @Nullable
    abstract RSP perform(@Nonnull Channel var1) throws EXC;

    Request() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="That is why we synchronize on the class.")
    Request(boolean recordCreatedAt) {
        super(recordCreatedAt);
        Class<Request> clazz = Request.class;
        synchronized (Request.class) {
            this.id = nextId++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void checkIfCanBeExecutedOnChannel(@Nonnull Channel channel) throws IOException {
        Throwable senderCloseCause = channel.getSenderCloseCause();
        if (senderCloseCause != null) {
            throw new ChannelClosedException(channel, senderCloseCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final RSP call(Channel channel) throws EXC, InterruptedException, IOException {
        Object object;
        this.checkIfCanBeExecutedOnChannel(channel);
        this.lastIoId = channel.lastIoId();
        Object object2 = channel;
        synchronized (object2) {
            object = this;
            synchronized (object) {
                this.response = null;
                channel.pendingCalls.put(this.id, this);
                this.startTime = System.nanoTime();
                channel.send(this);
            }
        }
        try {
            object2 = this;
            synchronized (object2) {
                Thread t = Thread.currentThread();
                String name = t.getName();
                try {
                    t.setName(name + " / waiting for " + channel.getName() + " id=" + this.id);
                    while (this.response == null && !channel.isInClosed()) {
                        this.wait(30000L);
                    }
                    if (this.response == null) {
                        throw new RequestAbortedException(null);
                    }
                }
                finally {
                    t.setName(name);
                }
                if (this.lastIo != null) {
                    try {
                        this.lastIo.get();
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
                try {
                    channel.pipeWriter.get(this.responseIoId).get();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                Object exc = this.response.exception;
                if (exc != null) {
                    channel.attachCallSiteStackTrace((Throwable)exc);
                    throw (Throwable)exc;
                }
                return (RSP)((Serializable)this.response.returnValue);
            }
        }
        catch (InterruptedException e) {
            object = channel;
            synchronized (object) {
                if (!channel.isOutClosed()) {
                    channel.send(new Cancel(this.id));
                }
            }
            throw e;
        }
    }

    final Future<RSP> callAsync(final Channel channel) throws IOException {
        this.checkIfCanBeExecutedOnChannel(channel);
        this.response = null;
        this.lastIoId = channel.lastIoId();
        channel.pendingCalls.put(this.id, this);
        this.startTime = System.nanoTime();
        channel.send(this);
        return new Future<RSP>(){
            private volatile boolean cancelled;

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.cancelled || this.isDone()) {
                    return false;
                }
                this.cancelled = true;
                if (mayInterruptIfRunning) {
                    try {
                        channel.send(new Cancel(Request.this.id));
                    }
                    catch (IOException x) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled;
            }

            @Override
            public boolean isDone() {
                return this.isCancelled() || Request.this.response != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RSP get() throws InterruptedException, ExecutionException {
                Request request = Request.this;
                synchronized (request) {
                    String oldThreadName = Thread.currentThread().getName();
                    Thread.currentThread().setName(oldThreadName + " for " + channel.getName() + " id=" + Request.this.id);
                    try {
                        while (Request.this.response == null) {
                            if (this.isCancelled()) {
                                throw new CancellationException();
                            }
                            if (channel.isInClosed()) {
                                throw new ExecutionException(new RequestAbortedException(null));
                            }
                            Request.this.wait(30000L);
                        }
                    }
                    catch (InterruptedException e) {
                        try {
                            channel.send(new Cancel(Request.this.id));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw e;
                    }
                    finally {
                        Thread.currentThread().setName(oldThreadName);
                    }
                    if (((Request)Request.this).response.exception != null) {
                        throw new ExecutionException((Throwable)((Request)Request.this).response.exception);
                    }
                    return (Serializable)((Request)Request.this).response.returnValue;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RSP get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                Request request = Request.this;
                synchronized (request) {
                    long now = System.nanoTime();
                    long end = now + unit.toNanos(timeout);
                    while (Request.this.response == null && end - now > 0L) {
                        if (this.isCancelled()) {
                            throw new CancellationException();
                        }
                        if (channel.isInClosed()) {
                            throw new ExecutionException(new RequestAbortedException(null));
                        }
                        Request.this.wait(Math.min(30000L, Math.max(1L, TimeUnit.NANOSECONDS.toMillis(end - now))));
                        now = System.nanoTime();
                    }
                    if (Request.this.response == null) {
                        throw new TimeoutException();
                    }
                    if (((Request)Request.this).response.exception != null) {
                        throw new ExecutionException((Throwable)((Request)Request.this).response.exception);
                    }
                    return (Serializable)((Request)Request.this).response.returnValue;
                }
            }
        };
    }

    synchronized void onCompleted(Response<RSP, EXC> response) {
        this.response = response;
        this.notifyAll();
    }

    void abort(IOException e) {
        this.onCompleted(new Response(this, this.id, 0, new RequestAbortedException(e)));
    }

    @Override
    final void execute(final Channel channel) {
        channel.executingCalls.put(this.id, this);
        this.future = channel.executor.submit(new Runnable(){
            private int startIoId;

            private int calcLastIoId() {
                int endIoId = channel.lastIoId();
                if (this.startIoId == endIoId) {
                    return 0;
                }
                return endIoId;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String oldThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName(oldThreadName + " for " + channel.getName() + " id=" + Request.this.id);
                try {
                    Response rsp;
                    CURRENT.set(Request.this);
                    this.startIoId = channel.lastIoId();
                    try {
                        channel.pipeWriter.get(Request.this.lastIoId).get();
                        Object r = Request.this.perform(channel);
                        rsp = new Response(Request.this, Request.this.id, this.calcLastIoId(), r);
                    }
                    catch (Throwable t) {
                        rsp = new Response(Request.this, Request.this.id, this.calcLastIoId(), t);
                    }
                    finally {
                        CURRENT.set(null);
                    }
                    if (chainCause) {
                        rsp.chainCause(Request.this.createdAt);
                    }
                    channel.send(rsp);
                }
                catch (IOException e) {
                    if (e instanceof ChannelClosedException && !logger.isLoggable(Level.FINE)) {
                        logger.log(Level.INFO, "Failed to send back a reply to the request {0}: {1}", new Object[]{this, e});
                    } else {
                        logger.log(Level.WARNING, "Failed to send back a reply to the request " + this, e);
                    }
                }
                finally {
                    channel.executingCalls.remove(Request.this.id);
                    Thread.currentThread().setName(oldThreadName);
                }
            }
        });
    }

    static int getCurrentRequestId() {
        Request r = CURRENT.get();
        return r != null ? r.id : 0;
    }

    private static final class Cancel
    extends Command {
        private final int id;
        private static final long serialVersionUID = -1709992419006993208L;

        Cancel(int id) {
            this.id = id;
        }

        @Override
        protected void execute(Channel channel) {
            Request<?, ?> r = channel.executingCalls.get(this.id);
            if (r == null) {
                return;
            }
            java.util.concurrent.Future<?> f = r.future;
            if (f != null) {
                f.cancel(true);
            }
        }

        @Override
        public String toString() {
            return "Request.Cancel";
        }
    }
}

