/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Channel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.remoting.engine.EngineUtil;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;
import org.jenkinsci.remoting.engine.LegacyJnlpConnectionState;
import org.jenkinsci.remoting.engine.LegacyJnlpProtocolHandler;
import org.jenkinsci.remoting.nio.NioChannelHub;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;

@Deprecated
public class JnlpProtocol1Handler
extends LegacyJnlpProtocolHandler<LegacyJnlpConnectionState> {
    private static final Logger LOGGER = Logger.getLogger(JnlpProtocol1Handler.class.getName());

    public JnlpProtocol1Handler(@Nullable JnlpClientDatabase clientDatabase, @Nonnull ExecutorService threadPool, @Nullable NioChannelHub hub, boolean preferNio) {
        super(clientDatabase, threadPool, hub, preferNio);
    }

    @Override
    public String getName() {
        return "JNLP-connect";
    }

    @Override
    @Nonnull
    public LegacyJnlpConnectionState createConnectionState(@Nonnull Socket socket, @Nonnull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        return new LegacyJnlpConnectionState(socket, listeners);
    }

    @Override
    void sendHandshake(@Nonnull LegacyJnlpConnectionState state, @Nonnull Map<String, String> headers) throws IOException, ConnectionRefusalException {
        String secretKey = headers.get("Secret-Key");
        if (secretKey == null) {
            throw new ConnectionRefusalException("Client headers missing Secret-Key");
        }
        String clientName = headers.get("Node-Name");
        if (clientName == null) {
            throw new ConnectionRefusalException("Client headers missing Node-Name");
        }
        state.fireBeforeProperties();
        DataOutputStream outputStream = state.getDataOutputStream();
        outputStream.writeUTF("Protocol:" + this.getName());
        outputStream.writeUTF(secretKey);
        outputStream.writeUTF(clientName);
        outputStream.flush();
        DataInputStream inputStream = state.getDataInputStream();
        String response = EngineUtil.readLine(inputStream);
        if (!response.equals("Welcome")) {
            throw new ConnectionRefusalException("Server didn't accept the handshake: " + response);
        }
        state.fireAfterProperties(new HashMap<String, String>());
    }

    @Override
    void receiveHandshake(@Nonnull LegacyJnlpConnectionState state, @Nonnull Map<String, String> headers) throws IOException {
        state.fireBeforeProperties();
        String secret = state.getDataInputStream().readUTF();
        String clientName = state.getDataInputStream().readUTF();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Node-Name", clientName);
        JnlpClientDatabase clientDatabase = this.getClientDatabase();
        if (clientDatabase == null || !clientDatabase.exists(clientName)) {
            throw new ConnectionRefusalException("Unknown client name: " + clientName);
        }
        String secretKey = clientDatabase.getSecretOf(clientName);
        if (secretKey == null) {
            throw new ConnectionRefusalException("Unknown client name: " + clientName);
        }
        if (!secretKey.equals(secret)) {
            LOGGER.log(Level.WARNING, "An attempt was made to connect as {0} from {1} with an incorrect secret", new Object[]{clientName, state.getSocket().getRemoteSocketAddress()});
            throw new ConnectionRefusalException("Authorization failure");
        }
        state.fireAfterProperties(properties);
        PrintWriter out = state.getPrintWriter();
        out.println("Welcome");
        out.flush();
    }

    @Override
    @Nonnull
    Channel buildChannel(@Nonnull LegacyJnlpConnectionState state) throws IOException {
        return state.getChannelBuilder().build(state.getSocket());
    }
}

