/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.SocketChannelStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;
import org.jenkinsci.remoting.engine.JnlpProtocolHandler;
import org.jenkinsci.remoting.protocol.IOHub;
import org.jenkinsci.remoting.protocol.NetworkLayer;
import org.jenkinsci.remoting.protocol.ProtocolStack;
import org.jenkinsci.remoting.protocol.impl.AckFilterLayer;
import org.jenkinsci.remoting.protocol.impl.AgentProtocolClientFilterLayer;
import org.jenkinsci.remoting.protocol.impl.BIONetworkLayer;
import org.jenkinsci.remoting.protocol.impl.ChannelApplicationLayer;
import org.jenkinsci.remoting.protocol.impl.ConnectionHeadersFilterLayer;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.jenkinsci.remoting.protocol.impl.NIONetworkLayer;

public class JnlpProtocol4PlainHandler
extends JnlpProtocolHandler<JnlpConnectionState> {
    private static final Logger LOGGER = Logger.getLogger(JnlpProtocol4PlainHandler.class.getName());
    @Nonnull
    private final ExecutorService threadPool;
    @Nonnull
    private final IOHub ioHub;

    public JnlpProtocol4PlainHandler(@Nullable JnlpClientDatabase clientDatabase, @Nonnull ExecutorService threadPool, @Nonnull IOHub ioHub, boolean preferNio) {
        super(clientDatabase, preferNio);
        this.threadPool = threadPool;
        this.ioHub = ioHub;
    }

    @Override
    public String getName() {
        return "JNLP4-plaintext";
    }

    @Override
    @Nonnull
    public JnlpConnectionState createConnectionState(@Nonnull Socket socket, @Nonnull List<? extends JnlpConnectionStateListener> listeners) {
        return new JnlpConnectionState(socket, listeners);
    }

    @Override
    @Nonnull
    public Future<Channel> handle(@Nonnull Socket socket, @Nonnull Map<String, String> headers, @Nonnull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        NetworkLayer networkLayer = this.createNetworkLayer(socket);
        Handler handler = new Handler(this.createConnectionState(socket, listeners), this.getClientDatabase());
        return ProtocolStack.on(networkLayer).filter(new AckFilterLayer()).filter(new ConnectionHeadersFilterLayer(headers, handler)).named(String.format("%s connection from %s", this.getName(), socket.getRemoteSocketAddress())).listener(handler).build(new ChannelApplicationLayer(this.threadPool, handler)).get();
    }

    @Override
    @Nonnull
    public Future<Channel> connect(@Nonnull Socket socket, @Nonnull Map<String, String> headers, @Nonnull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        NetworkLayer networkLayer = this.createNetworkLayer(socket);
        Handler handler = new Handler(this.createConnectionState(socket, listeners));
        return ProtocolStack.on(networkLayer).filter(new AgentProtocolClientFilterLayer(this.getName())).filter(new AckFilterLayer()).filter(new ConnectionHeadersFilterLayer(headers, handler)).named(String.format("%s connection to %s", this.getName(), socket.getRemoteSocketAddress())).listener(handler).build(new ChannelApplicationLayer(this.threadPool, handler)).get();
    }

    private NetworkLayer createNetworkLayer(Socket socket) throws IOException {
        SocketChannel socketChannel = this.isPreferNio() ? socket.getChannel() : null;
        NetworkLayer networkLayer = socketChannel == null ? new BIONetworkLayer(this.ioHub, Channels.newChannel(SocketChannelStream.in(socket)), Channels.newChannel(SocketChannelStream.out(socket))) : new NIONetworkLayer(this.ioHub, socketChannel, socketChannel);
        return networkLayer;
    }

    private class Handler
    extends Channel.Listener
    implements ConnectionHeadersFilterLayer.Listener,
    ChannelApplicationLayer.Listener,
    ProtocolStack.Listener,
    ChannelApplicationLayer.ChannelDecorator {
        @Nonnull
        private final JnlpConnectionState event;
        private JnlpClientDatabase clientDatabase;
        private boolean client;

        Handler(JnlpConnectionState event) {
            this.event = event;
            this.client = true;
        }

        Handler(JnlpConnectionState event, JnlpClientDatabase clientDatabase) {
            this.event = event;
            this.clientDatabase = clientDatabase;
            this.client = false;
        }

        @Override
        public void onReceiveHeaders(Map<String, String> headers) throws ConnectionRefusalException {
            this.event.fireBeforeProperties();
            if (!this.client) {
                String clientName = headers.get("Node-Name");
                if (this.clientDatabase == null || !this.clientDatabase.exists(clientName)) {
                    throw new ConnectionRefusalException("Unknown client name: " + clientName);
                }
                String secretKey = this.clientDatabase.getSecretOf(clientName);
                if (secretKey == null) {
                    throw new ConnectionRefusalException("Unknown client name: " + clientName);
                }
                if (!secretKey.equals(headers.get("Secret-Key"))) {
                    LOGGER.log(Level.WARNING, "An attempt was made to connect as {0} from {1} with an incorrect secret", new Object[]{clientName, this.event.getSocket().getRemoteSocketAddress()});
                    throw new ConnectionRefusalException("Authorization failure");
                }
            }
            this.event.fireAfterProperties(headers);
        }

        @Override
        public void onChannel(final @Nonnull Channel channel) {
            channel.addListener(this);
            JnlpProtocol4PlainHandler.this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    if (!channel.isClosingOrClosed()) {
                        Handler.this.event.fireAfterChannel(channel);
                    }
                }
            });
        }

        @Override
        @Nonnull
        public ChannelBuilder decorate(@Nonnull ChannelBuilder builder) {
            this.event.fireBeforeChannel(builder);
            return this.event.getChannelBuilder();
        }

        @Override
        public void onClosed(Channel channel, IOException cause) {
            this.event.fireChannelClosed(cause);
            try {
                this.event.getSocket().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClosed(ProtocolStack stack, IOException cause) {
            try {
                this.event.fireAfterDisconnect();
            }
            finally {
                stack.removeListener(this);
                try {
                    this.event.getSocket().close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

