/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpProtocol1Handler;
import org.jenkinsci.remoting.engine.JnlpProtocol2Handler;
import org.jenkinsci.remoting.engine.JnlpProtocol3Handler;
import org.jenkinsci.remoting.engine.JnlpProtocol4Handler;
import org.jenkinsci.remoting.engine.JnlpProtocol4PlainHandler;
import org.jenkinsci.remoting.engine.JnlpProtocolHandler;
import org.jenkinsci.remoting.nio.NioChannelHub;
import org.jenkinsci.remoting.protocol.IOHub;

public class JnlpProtocolHandlerFactory {
    private boolean needClientAuth;
    @CheckForNull
    private NioChannelHub nioChannelHub;
    @CheckForNull
    private IOHub ioHub;
    @CheckForNull
    private SSLContext context;
    @CheckForNull
    private JnlpClientDatabase clientDatabase;
    @Nonnull
    private final ExecutorService threadPool;
    private boolean preferNio = true;

    public JnlpProtocolHandlerFactory(@Nonnull ExecutorService threadPool) {
        this.threadPool = threadPool;
        this.needClientAuth = false;
    }

    public JnlpProtocolHandlerFactory withNioChannelHub(@CheckForNull NioChannelHub nioChannelHub) {
        this.nioChannelHub = nioChannelHub;
        return this;
    }

    public JnlpProtocolHandlerFactory withIOHub(@CheckForNull IOHub ioHub) {
        this.ioHub = ioHub;
        return this;
    }

    public JnlpProtocolHandlerFactory withSSLContext(@CheckForNull SSLContext context) {
        this.context = context;
        return this;
    }

    public JnlpProtocolHandlerFactory withSSLClientAuthRequired(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public JnlpProtocolHandlerFactory withPreferNonBlockingIO(boolean preferNio) {
        this.preferNio = preferNio;
        return this;
    }

    public JnlpProtocolHandlerFactory withClientDatabase(@CheckForNull JnlpClientDatabase clientDatabase) {
        this.clientDatabase = clientDatabase;
        return this;
    }

    @Nonnull
    public List<JnlpProtocolHandler> handlers() {
        ArrayList<JnlpProtocolHandler> result = new ArrayList<JnlpProtocolHandler>();
        if (this.ioHub != null && this.context != null) {
            result.add(new JnlpProtocol4Handler(this.clientDatabase, this.threadPool, this.ioHub, this.context, this.needClientAuth, this.preferNio));
        }
        if (this.ioHub != null) {
            result.add(new JnlpProtocol4PlainHandler(this.clientDatabase, this.threadPool, this.ioHub, this.preferNio));
        }
        result.add(new JnlpProtocol3Handler(this.clientDatabase, this.threadPool, this.nioChannelHub, this.preferNio));
        result.add(new JnlpProtocol2Handler(this.clientDatabase, this.threadPool, this.nioChannelHub, this.preferNio));
        result.add(new JnlpProtocol1Handler(this.clientDatabase, this.threadPool, this.nioChannelHub, this.preferNio));
        return result;
    }
}

