/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.RunMojo;

@Mojo(name="custom-war", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class WarMojo
extends RunMojo {
    @Parameter
    protected String jenkinsWarId;
    @Parameter
    protected File outputFile;
    @Component
    protected MavenProjectHelper projectHelper;

    @Override
    public void execute() throws MojoExecutionException {
        try {
            if (this.outputFile == null) {
                this.outputFile = new File(this.getProject().getBasedir(), "target/" + this.getProject().getArtifactId() + ".war");
            }
            File war = this.getJenkinsWarArtifact().getFile();
            Zip rezip = new Zip();
            rezip.setDestFile(this.outputFile);
            rezip.setProject(new Project());
            ZipFileSet z = new ZipFileSet();
            z.setSrc(war);
            rezip.addZipfileset(z);
            this.getProject().setArtifacts(this.resolveDependencies(this.dependencyResolution));
            for (MavenArtifact a : this.getProjectArtifacts()) {
                if (!a.isPlugin()) continue;
                Artifact hpi = this.artifactFactory.createArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), null, "hpi");
                this.artifactResolver.resolve(hpi, this.getProject().getRemoteArtifactRepositories(), this.localRepository);
                if (hpi.getFile().isDirectory()) {
                    throw new UnsupportedOperationException(hpi.getFile() + " is a directory and not packaged yet. this isn't supported");
                }
                z = new ZipFileSet();
                z.setFile(hpi.getFile());
                z.setFullpath("/WEB-INF/plugins/" + hpi.getArtifactId() + ".hpi");
                rezip.addZipfileset(z);
            }
            rezip.execute();
            this.getLog().info((CharSequence)("Generated " + this.outputFile));
            this.projectHelper.attachArtifact(this.getProject(), "war", this.outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to package war", (Exception)e);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to package war", (Exception)((Object)e));
        }
    }
}

