/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jodd.mail.CommonEmail;
import jodd.mail.EmailAttachment;
import jodd.mail.EmailAttachmentBuilder;
import jodd.mail.EmailMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email
extends CommonEmail {
    protected ArrayList<EmailAttachment> attachments;

    public static Email create() {
        return new Email();
    }

    public Email from(String from) {
        this.setFrom(from);
        return this;
    }

    public Email to(String to) {
        this.setTo(to);
        return this;
    }

    public Email to(String ... tos) {
        this.setTo(tos);
        return this;
    }

    public Email replyTo(String replyTo) {
        this.setReplyTo(replyTo);
        return this;
    }

    public Email replyTo(String ... replyTos) {
        this.setReplyTo(replyTos);
        return this;
    }

    public Email cc(String cc) {
        this.setCc(cc);
        return this;
    }

    public Email cc(String ... ccs) {
        this.setCc(ccs);
        return this;
    }

    public Email bcc(String bcc) {
        this.setBcc(bcc);
        return this;
    }

    public Email bcc(String ... bccs) {
        this.setBcc(bccs);
        return this;
    }

    public Email subject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public Email message(String text, String mimeType, String encoding) {
        this.addMessage(text, mimeType, encoding);
        return this;
    }

    public Email message(String text, String mimeType) {
        this.addMessage(text, mimeType);
        return this;
    }

    public Email addText(String text) {
        this.messages.add(new EmailMessage(text, "text/plain"));
        return this;
    }

    public Email addText(String text, String encoding) {
        this.messages.add(new EmailMessage(text, "text/plain", encoding));
        return this;
    }

    public Email addHtml(String message) {
        this.messages.add(new EmailMessage(message, "text/html"));
        return this;
    }

    public Email addHtml(String message, String encoding) {
        this.messages.add(new EmailMessage(message, "text/html", encoding));
        return this;
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public Email attach(EmailAttachment emailAttachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        this.attachments.add(emailAttachment);
        return this;
    }

    public Email embed(EmailAttachment emailAttachment) {
        int size;
        this.attach(emailAttachment);
        if (emailAttachment.isInline() && (size = this.messages.size()) > 0) {
            emailAttachment.setEmbeddedMessage((EmailMessage)this.messages.get(size - 1));
        }
        return this;
    }

    public Email attach(EmailAttachmentBuilder emailAttachmentBuilder) {
        emailAttachmentBuilder.setInline(false);
        this.attach(emailAttachmentBuilder.create());
        return this;
    }

    public Email embed(EmailAttachmentBuilder emailAttachmentBuilder) {
        emailAttachmentBuilder.setInline(true);
        this.embed(emailAttachmentBuilder.create());
        return this;
    }

    public Email header(String name, String value) {
        this.setHeader(name, value);
        return this;
    }

    public Email priority(int priority) {
        super.setPriority(priority);
        return this;
    }

    public Email setCurrentSentDate() {
        this.sentDate = new Date();
        return this;
    }

    public Email sentOn(Date date) {
        this.setSentDate(date);
        return this;
    }

    public String toString() {
        return "Email{'" + this.from + "', subject='" + this.subject + "'}";
    }
}

