/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Service;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.io.File;
import java.util.function.Consumer;
import jodd.mail.EmailFilter;
import jodd.mail.MailException;
import jodd.mail.MailSession;
import jodd.mail.ReceivedEmail;
import jodd.mail.ReceivedEmails;
import jodd.mail.ReceiverBuilder;

public class ReceiveMailSession
extends MailSession<Store> {
    protected static final String DEFAULT_FOLDER = "INBOX";
    Folder folder;
    String folderName;
    final File attachmentStorage;

    public ReceiveMailSession(Session session, Store store, File attachmentStorage) {
        super(session, (Service)store);
        this.attachmentStorage = attachmentStorage;
    }

    @Override
    public Store getService() {
        return (Store)this.service;
    }

    public String[] getAllFolders() {
        Folder[] folders;
        try {
            folders = this.getService().getDefaultFolder().list("*");
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to connect to folder", msgexc);
        }
        String[] folderNames = new String[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            Folder folder = folders[i];
            folderNames[i] = folder.getFullName();
        }
        return folderNames;
    }

    public void useFolder(String folderName) {
        this.useFolder(folderName, 2);
    }

    public void useFolder(String folderName, int mode) {
        ReceiveMailSession.closeFolderIfOpened(this.folder);
        try {
            this.folderName = folderName;
            this.folder = this.getService().getFolder(folderName);
            try {
                this.folder.open(mode);
            }
            catch (MailException ignore) {
                this.folder.open(1);
            }
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to connect to folder: " + folderName, msgexc);
        }
    }

    public Folder getFolder(String folder) {
        try {
            return this.getService().getFolder(folder);
        }
        catch (MessagingException e) {
            throw new MailException("Folder not found: " + folder, e);
        }
    }

    public void useDefaultFolder() {
        ReceiveMailSession.closeFolderIfOpened(this.folder);
        this.useFolder(DEFAULT_FOLDER);
    }

    private void useAndOpenFolderIfNotSet() {
        if (this.folder == null) {
            if (this.folderName != null) {
                this.useFolder(this.folderName);
            } else {
                this.useDefaultFolder();
            }
        }
    }

    public int getMessageCount() {
        this.useAndOpenFolderIfNotSet();
        try {
            return this.folder.getMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public int getNewMessageCount() {
        this.useAndOpenFolderIfNotSet();
        try {
            return this.folder.getNewMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public int getUnreadMessageCount() {
        this.useAndOpenFolderIfNotSet();
        try {
            return this.folder.getUnreadMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public int getDeletedMessageCount() {
        this.useAndOpenFolderIfNotSet();
        try {
            return this.folder.getDeletedMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public ReceiverBuilder receive() {
        return new ReceiverBuilder(this);
    }

    public ReceivedEmail[] receiveEmail() {
        return this.receiveMessages(null, null, null, false, null).fetch();
    }

    public ReceivedEmail[] receiveEmail(EmailFilter filter) {
        return this.receiveMessages(filter, null, null, false, null).fetch();
    }

    public ReceivedEmail[] receiveEmailAndMarkSeen() {
        return this.receiveEmailAndMarkSeen(null);
    }

    public ReceivedEmail[] receiveEmailAndMarkSeen(EmailFilter filter) {
        Flags flagsToSet = new Flags();
        flagsToSet.add(Flags.Flag.SEEN);
        return this.receiveMessages(filter, flagsToSet, null, false, null).fetch();
    }

    public ReceivedEmail[] receiveEmailAndDelete() {
        return this.receiveEmailAndDelete(null);
    }

    public ReceivedEmail[] receiveEmailAndDelete(EmailFilter filter) {
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        flags.add(Flags.Flag.DELETED);
        return this.receiveMessages(filter, flags, null, false, null).fetch();
    }

    public ReceivedEmail[] receiveEnvelopes() {
        return this.receiveEnvelopes(null);
    }

    public ReceivedEmail[] receiveEnvelopes(EmailFilter filter) {
        return this.receiveMessages(filter, null, null, true, null).fetch();
    }

    ReceivedEmails receiveMessages(EmailFilter filter, Flags flagsToSet, Flags flagsToUnset, boolean envelope, Consumer<Message[]> processedMessageConsumer) {
        this.useAndOpenFolderIfNotSet();
        try {
            Message[] messages = filter == null ? this.folder.getMessages() : this.folder.search(filter.getSearchTerm());
            return new ReceivedEmails(this, messages, flagsToSet, flagsToUnset, envelope, processedMessageConsumer);
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to fetch messages", msgexc);
        }
    }

    public void updateEmailFlags(ReceivedEmail receivedEmail) {
        this.useAndOpenFolderIfNotSet();
        try {
            this.folder.setFlags(new int[]{receivedEmail.messageNumber()}, receivedEmail.flags(), true);
        }
        catch (MessagingException mex) {
            throw new MailException("Failed to fetch messages", mex);
        }
    }

    protected static void closeFolderIfOpened(Folder folder) {
        if (folder != null && folder.isOpen()) {
            try {
                folder.close(true);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        ReceiveMailSession.closeFolderIfOpened(this.folder);
        this.folder = null;
        this.folderName = null;
        super.close();
    }

    static {
        ReceiveMailSession.setupSystemMailProperties();
    }
}

