/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.util.EDTUtil;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import jogamp.newt.DefaultEDTUtil;
import jogamp.newt.ScreenImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.event.NEWTEventTask;

public abstract class DisplayImpl
extends Display {
    private static int serialno = 1;
    public static final String nilString = "nil";
    private Object eventsLock = new Object();
    private ArrayList<NEWTEventTask> events = new ArrayList();
    private volatile boolean haveEvents = false;
    protected final Runnable dispatchMessagesRunnable = new Runnable(){

        @Override
        public void run() {
            DisplayImpl.this.dispatchMessages();
        }
    };
    protected EDTUtil edtUtil = null;
    protected int id;
    protected String name;
    protected String type;
    protected String fqname;
    protected int hashCode;
    protected int refCount;
    protected boolean exclusive;
    protected AbstractGraphicsDevice aDevice;

    static void initSingleton() {
    }

    private static Class<?> getDisplayClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "DisplayDriver");
        if (null == clazz) {
            throw new ClassNotFoundException("Failed to find NEWT Display Class <" + string + ".DisplayDriver>");
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display create(String string, String string2, long l, boolean bl) {
        try {
            Class<?> clazz = DisplayImpl.getDisplayClass(string);
            DisplayImpl displayImpl = (DisplayImpl)clazz.newInstance();
            string2 = displayImpl.validateDisplayName(string2, l);
            ArrayList arrayList = displayList;
            synchronized (arrayList) {
                Display display;
                if (bl && null != (display = Display.getLastDisplayOf(string, string2, -1, true))) {
                    if (DEBUG) {
                        System.err.println("Display.create() REUSE: " + display + " " + DisplayImpl.getThreadName());
                    }
                    return display;
                }
                displayImpl.exclusive = !bl;
                displayImpl.name = string2;
                displayImpl.type = string;
                displayImpl.refCount = 0;
                displayImpl.id = serialno++;
                displayImpl.fqname = DisplayImpl.getFQName(displayImpl.type, displayImpl.name, displayImpl.id);
                displayImpl.hashCode = displayImpl.fqname.hashCode();
                displayList.add(displayImpl);
            }
            displayImpl.setEDTUtil(displayImpl.edtUtil);
            if (DEBUG) {
                System.err.println("Display.create() NEW: " + displayImpl + " " + DisplayImpl.getThreadName());
            }
            return displayImpl;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DisplayImpl displayImpl = (DisplayImpl)object;
        if (this.id != displayImpl.id) {
            return false;
        }
        if (this.name == null ? displayImpl.name != null : !this.name.equals(displayImpl.name)) {
            return false;
        }
        return !(this.type == null ? displayImpl.type != null : !this.type.equals(displayImpl.type));
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void createNative() throws NativeWindowException {
        if (null == this.aDevice) {
            if (DEBUG) {
                System.err.println("Display.createNative() START (" + DisplayImpl.getThreadName() + ", " + this + ")");
            }
            final DisplayImpl displayImpl = this;
            try {
                this.runOnEDTIfAvail(true, new Runnable(){

                    @Override
                    public void run() {
                        displayImpl.createNativeImpl();
                    }
                });
            }
            catch (Throwable throwable) {
                throw new NativeWindowException(throwable);
            }
            if (null == this.aDevice) {
                throw new NativeWindowException("Display.createNative() failed to instanciate an AbstractGraphicsDevice");
            }
            if (DEBUG) {
                System.err.println("Display.createNative() END (" + DisplayImpl.getThreadName() + ", " + this + ")");
            }
            ArrayList arrayList = displayList;
            synchronized (arrayList) {
                ++displaysActive;
            }
        }
    }

    protected EDTUtil createEDTUtil() {
        DefaultEDTUtil defaultEDTUtil;
        if (NewtFactory.useEDT()) {
            defaultEDTUtil = new DefaultEDTUtil(Thread.currentThread().getThreadGroup(), "Display-" + this.getFQName(), this.dispatchMessagesRunnable);
            if (DEBUG) {
                System.err.println("Display.createNative(" + this.getFQName() + ") Create EDTUtil: " + defaultEDTUtil.getClass().getName());
            }
        } else {
            defaultEDTUtil = null;
        }
        return defaultEDTUtil;
    }

    @Override
    public EDTUtil setEDTUtil(EDTUtil eDTUtil) {
        EDTUtil eDTUtil2 = this.edtUtil;
        if (null == eDTUtil) {
            if (DEBUG) {
                System.err.println("Display.setEDTUtil(default): " + eDTUtil2 + " -> " + eDTUtil);
            }
            this.edtUtil = this.createEDTUtil();
        } else if (eDTUtil != this.edtUtil) {
            if (DEBUG) {
                System.err.println("Display.setEDTUtil(custom): " + eDTUtil2 + " -> " + eDTUtil);
            }
            this.removeEDT(null);
            this.edtUtil = eDTUtil;
        } else if (DEBUG) {
            System.err.println("Display.setEDTUtil: " + eDTUtil + " - keep!");
        }
        if (!this.edtUtil.isRunning()) {
            this.edtUtil.invoke(true, null);
        }
        return eDTUtil2;
    }

    @Override
    public final EDTUtil getEDTUtil() {
        return this.edtUtil;
    }

    private void removeEDT(Runnable runnable) {
        if (null != this.edtUtil) {
            this.edtUtil.invokeStop(true, runnable);
            this.edtUtil.waitUntilStopped();
            this.edtUtil.reset();
        } else {
            runnable.run();
        }
    }

    public void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        if (null != this.edtUtil && !this.edtUtil.isCurrentThreadEDT()) {
            this.edtUtil.invoke(bl, runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public boolean validateEDT() {
        if (0 == this.refCount && null == this.aDevice && null != this.edtUtil && this.edtUtil.isRunning()) {
            this.removeEDT(null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void destroy() {
        if (DEBUG) {
            DisplayImpl.dumpDisplayList("Display.destroy(" + this.getFQName() + ") BEGIN");
        }
        Object object = displayList;
        synchronized (object) {
            displayList.remove(this);
            if (0 < displaysActive) {
                --displaysActive;
            }
        }
        if (DEBUG) {
            System.err.println("Display.destroy(): " + this + " " + DisplayImpl.getThreadName());
        }
        object = this;
        this.removeEDT(new Runnable((DisplayImpl)object){
            final /* synthetic */ DisplayImpl val$f_dpy;
            {
                this.val$f_dpy = displayImpl2;
            }

            @Override
            public void run() {
                if (null != DisplayImpl.this.aDevice) {
                    this.val$f_dpy.closeNativeImpl();
                }
            }
        });
        this.aDevice = null;
        this.refCount = 0;
        if (DEBUG) {
            DisplayImpl.dumpDisplayList("Display.destroy(" + this.getFQName() + ") END");
        }
    }

    static final void shutdownAll() {
        int n = displayList.size();
        if (DEBUG) {
            DisplayImpl.dumpDisplayList("Display.shutdownAll " + n + " instances, on thread " + DisplayImpl.getThreadName());
        }
        for (int i = 0; i < n && displayList.size() > 0; ++i) {
            final DisplayImpl displayImpl = (DisplayImpl)displayList.remove(0);
            if (0 < displaysActive) {
                --displaysActive;
            }
            if (DEBUG) {
                System.err.println("Display.shutdownAll[" + (i + 1) + "/" + n + "]: " + displayImpl);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (null != displayImpl.getGraphicsDevice()) {
                        displayImpl.closeNativeImpl();
                    }
                }
            };
            EDTUtil eDTUtil = displayImpl.getEDTUtil();
            if (null != eDTUtil) {
                long l = eDTUtil.getPollPeriod() * 2L;
                eDTUtil.invokeStop(false, runnable);
                try {
                    Thread.sleep(l < 50L ? l : 50L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                runnable.run();
            }
            displayImpl.aDevice = null;
            displayImpl.refCount = 0;
        }
    }

    @Override
    public final synchronized int addReference() {
        if (DEBUG) {
            System.err.println("Display.addReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount + 1));
        }
        if (0 == this.refCount) {
            this.createNative();
        }
        if (null == this.aDevice) {
            throw new NativeWindowException("Display.addReference() (refCount " + this.refCount + ") null AbstractGraphicsDevice");
        }
        return this.refCount++;
    }

    @Override
    public final synchronized int removeReference() {
        if (DEBUG) {
            System.err.println("Display.removeReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount - 1));
        }
        --this.refCount;
        if (0 >= this.refCount) {
            this.destroy();
            this.refCount = 0;
        }
        return this.refCount;
    }

    @Override
    public final synchronized int getReferenceCount() {
        return this.refCount;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getFQName() {
        return this.fqname;
    }

    @Override
    public final boolean isExclusive() {
        return this.exclusive;
    }

    public String validateDisplayName(String string, long l) {
        if (null == string && 0L != l) {
            string = "wrapping-" + DisplayImpl.toHexString(l);
        }
        return null == string ? nilString : string;
    }

    private static String getFQName(String string, String string2, int n) {
        if (null == string) {
            string = nilString;
        }
        if (null == string2) {
            string2 = nilString;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("_");
        stringBuilder.append(string2);
        stringBuilder.append("-");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    @Override
    public final long getHandle() {
        if (null != this.aDevice) {
            return this.aDevice.getHandle();
        }
        return 0L;
    }

    @Override
    public final AbstractGraphicsDevice getGraphicsDevice() {
        return this.aDevice;
    }

    @Override
    public final synchronized boolean isNativeValid() {
        return null != this.aDevice;
    }

    @Override
    public boolean isEDTRunning() {
        if (null != this.edtUtil) {
            return this.edtUtil.isRunning();
        }
        return false;
    }

    public String toString() {
        return "NEWT-Display[" + this.getFQName() + ", excl " + this.exclusive + ", refCount " + this.refCount + ", hasEDT " + (null != this.edtUtil) + ", edtRunning " + this.isEDTRunning() + ", " + this.aDevice + "]";
    }

    protected abstract void dispatchMessagesNative();

    final void dispatchMessage(NEWTEvent nEWTEvent) {
        block4: {
            try {
                Object object = nEWTEvent.getSource();
                if (object instanceof NEWTEventConsumer) {
                    NEWTEventConsumer nEWTEventConsumer = (NEWTEventConsumer)object;
                    if (!nEWTEventConsumer.consumeEvent(nEWTEvent)) {
                        this.enqueueEvent(false, nEWTEvent);
                    }
                    break block4;
                }
                throw new RuntimeException("Event source not NEWT: " + object.getClass().getName() + ", " + object);
            }
            catch (Throwable throwable) {
                RuntimeException runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
                throw runtimeException;
            }
        }
    }

    final void dispatchMessage(NEWTEventTask nEWTEventTask) {
        NEWTEvent nEWTEvent = nEWTEventTask.get();
        try {
            if (null == nEWTEvent) {
                System.err.println("Warning: event of eventTask is NULL");
                Thread.dumpStack();
                return;
            }
            this.dispatchMessage(nEWTEvent);
        }
        catch (RuntimeException runtimeException) {
            if (nEWTEventTask.isCallerWaiting()) {
                nEWTEventTask.setException(runtimeException);
            }
            throw runtimeException;
        }
        nEWTEventTask.notifyCaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchMessages() {
        if (0 == this.refCount || null == this.getGraphicsDevice()) {
            return;
        }
        ArrayList<NEWTEventTask> arrayList = null;
        if (this.haveEvents) {
            Object object = this.eventsLock;
            synchronized (object) {
                if (this.haveEvents) {
                    arrayList = this.events;
                    this.events = new ArrayList();
                    this.haveEvents = false;
                }
                this.eventsLock.notifyAll();
            }
            if (null != arrayList) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.dispatchMessage(arrayList.get(i));
                }
            }
        }
        this.dispatchMessagesNative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        if (!this.isEDTRunning()) {
            if (DEBUG) {
                Throwable throwable = new Throwable("Warning: EDT already stopped: wait:=" + bl + ", " + nEWTEvent);
                throwable.printStackTrace();
            }
            return;
        }
        if (bl && this.edtUtil.isCurrentThreadEDTorNEDT()) {
            this.dispatchMessage(nEWTEvent);
            return;
        }
        Object object = new Object();
        NEWTEventTask nEWTEventTask = new NEWTEventTask(nEWTEvent, bl ? object : null);
        Object object2 = object;
        synchronized (object2) {
            Object object3 = this.eventsLock;
            synchronized (object3) {
                this.events.add(nEWTEventTask);
                this.haveEvents = true;
                this.eventsLock.notifyAll();
            }
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                if (null != nEWTEventTask.getException()) {
                    throw nEWTEventTask.getException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T runWithLockedDevice(AbstractGraphicsDevice abstractGraphicsDevice, DisplayRunnable<T> displayRunnable) {
        T t;
        abstractGraphicsDevice.lock();
        try {
            t = displayRunnable.run(abstractGraphicsDevice.getHandle());
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
        return t;
    }

    public final <T> T runWithLockedDisplayDevice(DisplayRunnable<T> displayRunnable) {
        AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsDevice();
        if (null == abstractGraphicsDevice) {
            throw new RuntimeException("null device - not initialized: " + this);
        }
        return DisplayImpl.runWithLockedDevice(abstractGraphicsDevice, displayRunnable);
    }

    static {
        NativeWindowFactory.addCustomShutdownHook(true, new Runnable(){

            @Override
            public void run() {
                WindowImpl.shutdownAll();
                ScreenImpl.shutdownAll();
                DisplayImpl.shutdownAll();
            }
        });
    }

    public static interface DisplayRunnable<T> {
        public T run(long var1);
    }
}

