/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.IntLongHashMap;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.GLBufferStateTracker;

public class GLBufferSizeTracker {
    private IntLongHashMap bufferSizeMap = new IntLongHashMap();
    protected static final boolean DEBUG = Debug.isPropertyDefined((String)"jogl.debug.GLBufferSizeTracker", (boolean)true);

    public GLBufferSizeTracker() {
        this.bufferSizeMap.setKeyNotFoundValue(-1L);
    }

    public final void setBufferSize(GLBufferStateTracker gLBufferStateTracker, int n, GL gL, long l) {
        int n2 = gLBufferStateTracker.getBoundBufferObject(n, gL);
        if (n2 != 0) {
            this.setDirectStateBufferSize(n2, gL, l);
        }
    }

    public final void setDirectStateBufferSize(int n, GL gL, long l) {
        this.bufferSizeMap.put(n, l);
    }

    public final long getBufferSize(GLBufferStateTracker gLBufferStateTracker, int n, GL gL) {
        int n2 = gLBufferStateTracker.getBoundBufferObject(n, gL);
        if (0 != n2) {
            return this.getBufferSizeImpl(n, n2, gL);
        }
        int[] nArray = new int[1];
        gL.glGetBufferParameteriv(n, 34660, nArray, 0);
        if (DEBUG) {
            System.err.println("GLBufferSizeTracker.getBufferSize(): no cached buffer information");
        }
        return nArray[0];
    }

    public final long getDirectStateBufferSize(int n, GL gL) {
        return this.getBufferSizeImpl(0, n, gL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final long getBufferSizeImpl(int n, int n2, GL gL) {
        long l = this.bufferSizeMap.get(n2);
        if (-1L != l) return l;
        int[] nArray = new int[1];
        if (0 == n) {
            if (!gL.isFunctionAvailable("glGetNamedBufferParameterivEXT")) throw new GLException("Error: getDirectStateBufferSize called with unknown state and GL function 'glGetNamedBufferParameterivEXT' n/a to query size");
            gL.getGL2().glGetNamedBufferParameterivEXT(n2, 34660, nArray, 0);
        } else {
            gL.glGetBufferParameteriv(n, 34660, nArray, 0);
        }
        if (nArray[0] == 0) {
            throw new GLException("Error: buffer size returned by " + (0 == n ? "glGetNamedBufferParameterivEXT" : "glGetBufferParameteriv") + " was zero; probably application error");
        }
        l = nArray[0];
        this.bufferSizeMap.put(n2, l);
        if (!DEBUG) return l;
        System.err.println("GLBufferSizeTracker.getBufferSize(): made slow query to cache size " + l + " for buffer " + n2);
        return l;
    }

    public final void clearCachedBufferSizes() {
        this.bufferSizeMap.clear();
    }
}

