/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.nativewindow.DelegatedUpstreamSurfaceHookWithSurfaceSize;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.Buffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLFBODrawable;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLFBODrawableImpl;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.GLOffscreenAutoDrawableImpl;
import jogamp.opengl.GLPbufferImpl;
import jogamp.opengl.SharedResourceRunner;

public abstract class GLDrawableFactoryImpl
extends GLDrawableFactory {
    protected static final boolean DEBUG = GLDrawableFactory.DEBUG;
    private volatile Buffer originalGammaRamp;
    private volatile boolean needsGammaRampReset = false;

    protected GLDrawableFactoryImpl() {
    }

    protected final SharedResourceRunner.Resource getOrCreateSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        block3: {
            try {
                abstractGraphicsDevice = this.validateDevice(abstractGraphicsDevice);
                if (null != abstractGraphicsDevice) {
                    return this.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
                }
            }
            catch (GLException gLException) {
                if (!DEBUG) break block3;
                System.err.println("Catched Exception on thread " + GLDrawableFactoryImpl.getThreadName());
                gLException.printStackTrace();
            }
        }
        return null;
    }

    protected abstract SharedResourceRunner.Resource getOrCreateSharedResourceImpl(AbstractGraphicsDevice var1);

    public final GLContext getOrCreateSharedContext(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getContext();
        }
        return null;
    }

    @Override
    protected final boolean createSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null != resource) {
            return resource.isValid();
        }
        return false;
    }

    @Override
    public final GLRendererQuirks getRendererQuirks(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getRendererQuirks();
        }
        return null;
    }

    protected final AbstractGraphicsDevice getOrCreateSharedDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getDevice();
        }
        return null;
    }

    public abstract GLDynamicLookupHelper getGLDynamicLookupHelper(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLDrawable createGLDrawable(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        MutableGraphicsConfiguration mutableGraphicsConfiguration = (MutableGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getChosenCapabilities();
        AbstractGraphicsDevice abstractGraphicsDevice = mutableGraphicsConfiguration.getScreen().getDevice();
        boolean bl = GLContext.isFBOAvailable(abstractGraphicsDevice, gLCapabilitiesImmutable.getGLProfile());
        GLDrawable gLDrawable = null;
        abstractGraphicsDevice.lock();
        try {
            OffscreenLayerSurface offscreenLayerSurface = NativeWindowFactory.getOffscreenLayerSurface(nativeSurface, true);
            if (null != offscreenLayerSurface) {
                GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, this, abstractGraphicsDevice);
                if (!gLCapabilitiesImmutable2.isFBO() && !gLCapabilitiesImmutable2.isPBuffer()) {
                    throw new GLException("Neither FBO nor Pbuffer is available for " + gLCapabilitiesImmutable2 + ", " + nativeSurface);
                }
                mutableGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable2);
                offscreenLayerSurface.setChosenCapabilities(gLCapabilitiesImmutable2);
                if (DEBUG) {
                    System.err.println("GLDrawableFactoryImpl.createGLDrawable -> OnscreenDrawable -> Offscreen-Layer");
                    System.err.println("chosenCaps:    " + gLCapabilitiesImmutable);
                    System.err.println("chosenCapsMod: " + gLCapabilitiesImmutable2);
                    System.err.println("OffscreenLayerSurface: **** " + offscreenLayerSurface);
                    System.err.println("Target: **** " + nativeSurface);
                    Thread.dumpStack();
                }
                if (!(nativeSurface instanceof MutableSurface)) {
                    throw new IllegalArgumentException("Passed NativeSurface must implement SurfaceChangeable for offscreen layered surface: " + nativeSurface);
                }
                gLDrawable = gLCapabilitiesImmutable2.isFBO() ? this.createFBODrawableImpl(nativeSurface, gLCapabilitiesImmutable2, 0) : this.createOffscreenDrawableImpl(nativeSurface);
            } else if (gLCapabilitiesImmutable.isOnscreen()) {
                GLCapabilitiesImmutable gLCapabilitiesImmutable3 = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
                mutableGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable3);
                if (DEBUG) {
                    System.err.println("GLDrawableFactoryImpl.createGLDrawable -> OnscreenDrawable: " + nativeSurface);
                }
                gLDrawable = this.createOnscreenDrawableImpl(nativeSurface);
            } else {
                if (DEBUG) {
                    System.err.println("GLDrawableFactoryImpl.createGLDrawable -> OffScreenDrawable, FBO chosen / avail, PBuffer: " + gLCapabilitiesImmutable.isFBO() + " / " + bl + ", " + gLCapabilitiesImmutable.isPBuffer() + ": " + nativeSurface);
                }
                if (!(nativeSurface instanceof MutableSurface)) {
                    throw new IllegalArgumentException("Passed NativeSurface must implement MutableSurface for offscreen: " + nativeSurface);
                }
                if (gLCapabilitiesImmutable.isFBO() && bl) {
                    ProxySurface proxySurface = this.createDummySurfaceImpl(abstractGraphicsDevice, false, new GLCapabilities(gLCapabilitiesImmutable.getGLProfile()), (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getRequestedCapabilities(), null, 64, 64);
                    proxySurface.setUpstreamSurfaceHook(new DelegatedUpstreamSurfaceHookWithSurfaceSize(proxySurface.getUpstreamSurfaceHook(), nativeSurface));
                    gLDrawable = this.createFBODrawableImpl(proxySurface, gLCapabilitiesImmutable, 0);
                } else {
                    gLDrawable = this.createOffscreenDrawableImpl(nativeSurface);
                }
            }
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
        if (DEBUG) {
            System.err.println("GLDrawableFactoryImpl.createGLDrawable: " + gLDrawable);
        }
        return gLDrawable;
    }

    protected abstract GLDrawableImpl createOnscreenDrawableImpl(NativeSurface var1);

    @Override
    public abstract boolean canCreateGLPbuffer(AbstractGraphicsDevice var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLPbuffer createGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2, GLContext gLContext) {
        if (n <= 0 || n2 <= 0) {
            throw new GLException("initial size must be positive (were (" + n + " x " + n2 + "))");
        }
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        if (!this.canCreateGLPbuffer(abstractGraphicsDevice2)) {
            throw new GLException("Pbuffer not available with device: " + abstractGraphicsDevice2);
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLPBufferGLCapabilities(gLCapabilitiesImmutable);
        GLDrawableImpl gLDrawableImpl = null;
        abstractGraphicsDevice2.lock();
        try {
            gLDrawableImpl = this.createOffscreenDrawableImpl(this.createMutableSurfaceImpl(abstractGraphicsDevice2, true, gLCapabilitiesImmutable2, gLCapabilitiesImmutable, gLCapabilitiesChooser, new UpstreamSurfaceHookMutableSize(n, n2)));
            if (null != gLDrawableImpl) {
                gLDrawableImpl.setRealized(true);
            }
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
        return new GLPbufferImpl(gLDrawableImpl, (GLContextImpl)gLDrawableImpl.createContext(gLContext));
    }

    @Override
    public final boolean canCreateFBO(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        return GLContext.isFBOAvailable(abstractGraphicsDevice2, gLProfile);
    }

    @Override
    public GLOffscreenAutoDrawable createOffscreenAutoDrawable(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2, GLContext gLContext) {
        GLDrawable gLDrawable = this.createOffscreenDrawable(abstractGraphicsDevice, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2);
        gLDrawable.setRealized(true);
        GLContext gLContext2 = gLDrawable.createContext(gLContext);
        if (gLDrawable instanceof GLFBODrawableImpl) {
            return new GLOffscreenAutoDrawableImpl.FBOImpl((GLFBODrawableImpl)gLDrawable, gLContext2, null, null);
        }
        return new GLOffscreenAutoDrawableImpl(gLDrawable, gLContext2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLDrawable createOffscreenDrawable(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new GLException("initial size must be positive (were (" + n + " x " + n2 + "))");
        }
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, this, abstractGraphicsDevice2);
        abstractGraphicsDevice2.lock();
        try {
            if (gLCapabilitiesImmutable2.isFBO()) {
                ProxySurface proxySurface = this.createDummySurfaceImpl(abstractGraphicsDevice2, true, new GLCapabilities(gLCapabilitiesImmutable2.getGLProfile()), gLCapabilitiesImmutable, null, n, n2);
                GLDrawableImpl gLDrawableImpl = this.createOnscreenDrawableImpl(proxySurface);
                GLFBODrawableImpl.ResizeableImpl resizeableImpl = new GLFBODrawableImpl.ResizeableImpl(this, gLDrawableImpl, proxySurface, gLCapabilitiesImmutable2, 0);
                return resizeableImpl;
            }
            GLDrawableImpl gLDrawableImpl = this.createOffscreenDrawableImpl(this.createMutableSurfaceImpl(abstractGraphicsDevice2, true, gLCapabilitiesImmutable2, gLCapabilitiesImmutable, gLCapabilitiesChooser, new UpstreamSurfaceHookMutableSize(n, n2)));
            return gLDrawableImpl;
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
    }

    protected GLFBODrawable createFBODrawableImpl(NativeSurface nativeSurface, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n) {
        GLDrawableImpl gLDrawableImpl = this.createOnscreenDrawableImpl(nativeSurface);
        return new GLFBODrawableImpl(this, gLDrawableImpl, nativeSurface, gLCapabilitiesImmutable, n);
    }

    protected abstract GLDrawableImpl createOffscreenDrawableImpl(NativeSurface var1);

    protected abstract ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice var1, boolean var2, GLCapabilitiesImmutable var3, GLCapabilitiesImmutable var4, GLCapabilitiesChooser var5, UpstreamSurfaceHook var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxySurface createDummySurface(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        abstractGraphicsDevice2.lock();
        try {
            ProxySurface proxySurface = this.createDummySurfaceImpl(abstractGraphicsDevice2, true, gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2);
            return proxySurface;
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
    }

    public abstract ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice var1, boolean var2, GLCapabilitiesImmutable var3, GLCapabilitiesImmutable var4, GLCapabilitiesChooser var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxySurface createProxySurface(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        if (0L == l) {
            throw new IllegalArgumentException("Null windowHandle");
        }
        abstractGraphicsDevice2.lock();
        try {
            ProxySurface proxySurface = this.createProxySurfaceImpl(abstractGraphicsDevice2, n, l, gLCapabilitiesImmutable, gLCapabilitiesChooser, upstreamSurfaceHook);
            return proxySurface;
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
    }

    protected abstract ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice var1, int var2, long var3, GLCapabilitiesImmutable var5, GLCapabilitiesChooser var6, UpstreamSurfaceHook var7);

    protected abstract GLContext createExternalGLContextImpl();

    @Override
    public GLContext createExternalGLContext() {
        return this.createExternalGLContextImpl();
    }

    protected abstract GLDrawable createExternalGLDrawableImpl();

    @Override
    public GLDrawable createExternalGLDrawable() {
        return this.createExternalGLDrawableImpl();
    }

    public static GLDrawableFactoryImpl getFactoryImpl(GLProfile gLProfile) {
        return (GLDrawableFactoryImpl)GLDrawableFactoryImpl.getFactory(gLProfile);
    }

    public boolean setDisplayGamma(float f, float f2, float f3) throws IllegalArgumentException {
        if (f2 < -1.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Brightness must be between -1.0 and 1.0");
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("Contrast must be greater than 0.0");
        }
        int n = this.getGammaRampLength();
        if (n == 0) {
            return false;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            float f4 = (float)i / (float)(n - 1);
            float f5 = (float)Math.pow(f4, f);
            f5 += f2;
            if ((f5 = (f5 - 0.5f) * f3 + 0.5f) > 1.0f) {
                f5 = 1.0f;
            } else if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            fArray[i] = f5;
        }
        this.needsGammaRampReset = true;
        return this.setGammaRamp(fArray);
    }

    @Override
    public synchronized void resetDisplayGamma() {
        if (this.needsGammaRampReset) {
            this.resetGammaRamp(this.originalGammaRamp);
            this.needsGammaRampReset = false;
        }
    }

    protected int getGammaRampLength() {
        return 0;
    }

    protected boolean setGammaRamp(float[] fArray) {
        return false;
    }

    protected Buffer getGammaRamp() {
        return null;
    }

    protected void resetGammaRamp(Buffer buffer) {
    }
}

