/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jdom.Element;
import org.jopendocument.dom.ODFrame;
import org.jopendocument.util.ImageInfo;
import org.jopendocument.util.ImageUtils;

abstract class BytesProducer {
    BytesProducer() {
    }

    abstract byte[] getBytes(ODFrame<?> var1);

    abstract String getFormat();

    static final class ImageProducer
    extends BytesProducer {
        private final Image img;
        private final boolean keepRatio;

        public ImageProducer(Image image, boolean bl) {
            this.img = image;
            this.keepRatio = bl;
        }

        @Override
        public byte[] getBytes(ODFrame<?> oDFrame) {
            BufferedImage bufferedImage;
            if (this.keepRatio) {
                float f = (float)oDFrame.getRatio();
                bufferedImage = ImageUtils.createQualityResizedImage(this.img, f, true, Color.WHITE, true);
            } else {
                bufferedImage = ImageUtils.createQualityResizedImage(this.img, this.img.getWidth(null), this.img.getHeight(null), true, true, Color.WHITE, true);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0x100000);
            try {
                ImageIO.write((RenderedImage)bufferedImage, this.getFormat(), byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("unable to export " + bufferedImage + " to " + this.getFormat());
            }
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public String getFormat() {
            return "png";
        }
    }

    static final class ByteArrayProducer
    extends BytesProducer {
        private final byte[] data;
        private final boolean keepRatio;

        public ByteArrayProducer(byte[] byArray) {
            this(byArray, false);
        }

        public ByteArrayProducer(byte[] byArray, boolean bl) {
            this.data = byArray;
            this.keepRatio = bl;
        }

        @Override
        public byte[] getBytes(ODFrame<?> oDFrame) {
            if (this.keepRatio) {
                double d;
                double d2;
                ImageInfo imageInfo = new ImageInfo();
                imageInfo.setInput(new ByteArrayInputStream(this.data));
                if (!imageInfo.check()) {
                    throw new IllegalStateException("unable to parse the picture");
                }
                double d3 = (double)imageInfo.getWidth() / (double)imageInfo.getHeight();
                if (d3 > (d2 = oDFrame.getRatio())) {
                    d = oDFrame.getWidth().doubleValue() / d3;
                    double d4 = oDFrame.getHeight().doubleValue() - d;
                    oDFrame.setSVGAttr("y", oDFrame.getY().doubleValue() + d4 / 2.0);
                    oDFrame.setSVGAttr("height", d);
                } else {
                    d = oDFrame.getHeight().doubleValue() * d3;
                    double d5 = oDFrame.getWidth().doubleValue() - d;
                    oDFrame.setSVGAttr("x", oDFrame.getX().doubleValue() + d5 / 2.0);
                    oDFrame.setSVGAttr("width", d);
                }
                Element element = oDFrame.getElement();
                element.removeAttribute("end-cell-address", element.getNamespace("table"));
                element.removeAttribute("end-x", element.getNamespace("table"));
                element.removeAttribute("end-y", element.getNamespace("table"));
            }
            return this.data;
        }

        @Override
        public String getFormat() {
            return null;
        }
    }
}

