/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import org.dmg.pmml.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class ImportFilter
extends XMLFilterImpl {
    private static final Version version = Version.PMML_4_1;

    public ImportFilter() {
    }

    public ImportFilter(XMLReader parent) {
        super(parent);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        super.startElement(this.filterNamespaceURI(namespaceURI), this.filterLocalName(namespaceURI, localName), qualifiedName, attributes);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        super.endElement(this.filterNamespaceURI(namespaceURI), this.filterLocalName(namespaceURI, localName), qualifiedName);
    }

    private String filterNamespaceURI(String namespaceURI) {
        Version version = ImportFilter.forNamespaceURI(namespaceURI);
        if (version.compareTo(Version.PMML_3_0) >= 0 && version.compareTo(Version.PMML_4_1) <= 0) {
            return ImportFilter.version.getNamespaceURI();
        }
        return namespaceURI;
    }

    private String filterLocalName(String namespaceURI, String localName) {
        Version version = ImportFilter.forNamespaceURI(namespaceURI);
        if (version.equals((Object)Version.PMML_4_0) && "Trend".equals(localName)) {
            return "Trend_ExpoSmooth";
        }
        return localName;
    }

    private static Version forNamespaceURI(String namespaceURI) {
        if ("".equals(namespaceURI)) {
            return version;
        }
        return Version.forNamespaceURI(namespaceURI);
    }
}

