/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.input;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.jxmapviewer.JXMapViewer;

public class PanMouseInputListener
extends MouseInputAdapter {
    private Point prev;
    private JXMapViewer viewer;
    private Cursor priorCursor;

    public PanMouseInputListener(JXMapViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.prev = evt.getPoint();
        this.priorCursor = this.viewer.getCursor();
        this.viewer.setCursor(Cursor.getPredefinedCursor(13));
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        int maxHeight;
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        Point current = evt.getPoint();
        double x = this.viewer.getCenter().getX();
        double y = this.viewer.getCenter().getY();
        if (this.prev != null) {
            x += (double)(this.prev.x - current.x);
            y += (double)(this.prev.y - current.y);
        }
        if (!this.viewer.isNegativeYAllowed() && y < 0.0) {
            y = 0.0;
        }
        if (y > (double)(maxHeight = (int)(this.viewer.getTileFactory().getMapSize(this.viewer.getZoom()).getHeight() * (double)this.viewer.getTileFactory().getTileSize(this.viewer.getZoom())))) {
            y = maxHeight;
        }
        this.prev = current;
        this.viewer.setCenter(new Point2D.Double(x, y));
        this.viewer.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.prev = null;
        this.viewer.setCursor(this.priorCursor);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanMouseInputListener.this.viewer.requestFocusInWindow();
            }
        });
    }
}

