/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.viewer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.Waypoint;
import org.jxmapviewer.viewer.WaypointRenderer;

public class DefaultWaypointRenderer
implements WaypointRenderer<Waypoint> {
    private static final Log log = LogFactory.getLog(DefaultWaypointRenderer.class);
    private BufferedImage img = null;

    public DefaultWaypointRenderer() {
        try {
            this.img = ImageIO.read(DefaultWaypointRenderer.class.getResource("/images/standard_waypoint.png"));
        }
        catch (Exception ex) {
            log.warn((Object)"couldn't read standard_waypoint.png", (Throwable)ex);
        }
    }

    @Override
    public void paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint w) {
        if (this.img == null) {
            return;
        }
        Point2D point = map.getTileFactory().geoToPixel(w.getPosition(), map.getZoom());
        int x = (int)point.getX() - this.img.getWidth() / 2;
        int y = (int)point.getY() - this.img.getHeight();
        g.drawImage((Image)this.img, x, y, null);
    }
}

