/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.heatmap;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.knowm.xchart.HeatMapChart;
import org.knowm.xchart.HeatMapChartBuilder;
import org.knowm.xchart.HeatMapSeries;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.HeatMapStyler;

public class HeatMapChart02
implements ExampleChart<HeatMapChart> {
    public static void main(String[] args) {
        HeatMapChart02 exampleChart = new HeatMapChart02();
        HeatMapChart chart = (HeatMapChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public HeatMapChart getChart() {
        HeatMapChart chart = ((HeatMapChartBuilder)((HeatMapChartBuilder)((HeatMapChartBuilder)new HeatMapChartBuilder().width(800)).height(600)).title(this.getClass().getSimpleName())).build();
        Color[] rangeColors = new Color[]{new Color(255, 182, 193), new Color(255, 20, 147), new Color(139, 0, 0)};
        ((HeatMapStyler)chart.getStyler()).setRangeColors(rangeColors);
        ArrayList<String> xData = new ArrayList<String>();
        BigDecimal bd = new BigDecimal("-2.0");
        while (bd.doubleValue() <= 2.0) {
            xData.add(bd.toString());
            bd = bd.add(new BigDecimal("0.04"));
        }
        ArrayList<String> yData = new ArrayList<String>();
        BigDecimal bd2 = new BigDecimal("-2.0");
        while (bd2.doubleValue() <= 2.0) {
            yData.add(bd2.toString());
            bd2 = bd2.add(new BigDecimal("0.02"));
        }
        ArrayList<Number[]> heatData = new ArrayList<Number[]>();
        for (int i = 0; i < xData.size(); ++i) {
            for (int j = 0; j < yData.size(); ++j) {
                Number[] numbers = new Number[]{i, j, Math.sin(Double.parseDouble((String)xData.get(i))) * Math.sin(Double.parseDouble((String)yData.get(j)))};
                heatData.add(numbers);
            }
        }
        HeatMapSeries heatMapSeries = chart.addSeries("heatMap", xData, yData, heatData);
        heatMapSeries.setMin(-1.0);
        heatMapSeries.setMax(1.0);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - HeatMap Large";
    }
}

