/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.line;

import java.awt.Color;
import java.awt.Font;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.ChartColor;
import org.knowm.xchart.style.colors.XChartSeriesColors;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class LineChart03
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        LineChart03 exampleChart = new LineChart03();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title(this.getClass().getSimpleName())).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setPlotBackgroundColor(ChartColor.GREY.getColor());
        ((XYStyler)chart.getStyler()).setPlotGridLinesColor(new Color(255, 255, 255));
        ((XYStyler)chart.getStyler()).setChartBackgroundColor(Color.WHITE);
        ((XYStyler)chart.getStyler()).setLegendBackgroundColor(Color.PINK);
        ((XYStyler)chart.getStyler()).setChartFontColor(Color.MAGENTA);
        ((XYStyler)chart.getStyler()).setChartTitleBoxBackgroundColor(new Color(0, 222, 0));
        ((XYStyler)chart.getStyler()).setChartTitleBoxVisible(true);
        ((XYStyler)chart.getStyler()).setChartTitleBoxBorderColor(Color.BLACK);
        ((XYStyler)chart.getStyler()).setPlotGridLinesVisible(false);
        ((XYStyler)chart.getStyler()).setAxisTickPadding(20);
        ((XYStyler)chart.getStyler()).setAxisTickMarkLength(15);
        ((XYStyler)chart.getStyler()).setPlotMargin(20);
        ((XYStyler)chart.getStyler()).setChartTitleFont(new Font("Monospaced", 1, 24));
        ((XYStyler)chart.getStyler()).setLegendFont(new Font("Serif", 0, 18));
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideSE);
        ((XYStyler)chart.getStyler()).setLegendSeriesLineLength(12);
        ((XYStyler)chart.getStyler()).setAxisTitleFont(new Font("SansSerif", 2, 18));
        ((XYStyler)chart.getStyler()).setAxisTickLabelsFont(new Font("Serif", 0, 11));
        ((XYStyler)chart.getStyler()).setDatePattern("dd-MMM");
        ((XYStyler)chart.getStyler()).setDecimalPattern("#0.000");
        ((XYStyler)chart.getStyler()).setLocale(Locale.GERMAN);
        ArrayList<Date> xData = new ArrayList<Date>();
        ArrayList<Double> yData = new ArrayList<Double>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        Date date = null;
        for (int i = 1; i <= 10; ++i) {
            try {
                date = sdf.parse(i + ".10.2008");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            xData.add(date);
            yData.add(Math.random() * (double)i);
        }
        XYSeries series = chart.addSeries("Fake Data", xData, yData);
        series.setLineColor(XChartSeriesColors.BLUE);
        series.setMarkerColor(Color.ORANGE);
        series.setMarker(SeriesMarkers.CIRCLE);
        series.setLineStyle(SeriesLines.SOLID);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Extensive Chart Customization";
    }
}

