/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.ohlc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.knowm.xchart.OHLCChart;
import org.knowm.xchart.OHLCChartBuilder;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.OHLCStyler;
import org.knowm.xchart.style.Styler;

public class OHLCChart01
implements ExampleChart<OHLCChart> {
    public static void main(String[] args) {
        OHLCChart01 exampleChart = new OHLCChart01();
        OHLCChart chart = (OHLCChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    public static void populateData(List<Date> xData, List<Double> openData, List<Double> highData, List<Double> lowData, List<Double> closeData) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sdf.parse("2017-01-01");
            OHLCChart01.populateData(date, 5000.0, 20, xData, openData, highData, lowData, closeData);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void populateData(Date startDate, double startPrice, int count, List<Date> xData, List<Double> openData, List<Double> highData, List<Double> lowData, List<Double> closeData) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        double data = startPrice;
        for (int i = 1; i <= count; ++i) {
            cal.add(5, 1);
            xData.add(cal.getTime());
            double previous = data;
            data = OHLCChart01.getNewClose(data, startPrice);
            openData.add(previous);
            highData.add(OHLCChart01.getHigh(Math.max(previous, data), startPrice));
            lowData.add(OHLCChart01.getLow(Math.min(previous, data), startPrice));
            closeData.add(data);
        }
    }

    private static double getHigh(double close, double orig) {
        return close + orig * Math.random() * 0.02;
    }

    private static double getLow(double close, double orig) {
        return close - orig * Math.random() * 0.02;
    }

    private static double getNewClose(double close, double orig) {
        return close + orig * (Math.random() - 0.5) * 0.1;
    }

    @Override
    public OHLCChart getChart() {
        OHLCChart chart = ((OHLCChartBuilder)((OHLCChartBuilder)((OHLCChartBuilder)new OHLCChartBuilder().width(800)).height(600)).title("OHLCChart01")).build();
        ((OHLCStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.OutsideS);
        ((OHLCStyler)chart.getStyler()).setLegendLayout(Styler.LegendLayout.Horizontal);
        ArrayList<Date> xData = new ArrayList<Date>();
        ArrayList<Double> openData = new ArrayList<Double>();
        ArrayList<Double> highData = new ArrayList<Double>();
        ArrayList<Double> lowData = new ArrayList<Double>();
        ArrayList<Double> closeData = new ArrayList<Double>();
        OHLCChart01.populateData(xData, openData, highData, lowData, closeData);
        xData = null;
        chart.addSeries("Series", xData, openData, highData, lowData, closeData);
        ((OHLCStyler)chart.getStyler()).setToolTipsEnabled(true);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - HiLo rendering";
    }
}

