/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.ohlc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.knowm.xchart.OHLCChart;
import org.knowm.xchart.OHLCChartBuilder;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.demo.charts.ohlc.OHLCChart01;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.OHLCStyler;
import org.knowm.xchart.style.Styler;

public class OHLCChart03
implements ExampleChart<OHLCChart> {
    public static void main(String[] args) {
        OHLCChart03 exampleChart = new OHLCChart03();
        OHLCChart chart = (OHLCChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public OHLCChart getChart() {
        OHLCChart chart = ((OHLCChartBuilder)((OHLCChartBuilder)((OHLCChartBuilder)new OHLCChartBuilder().width(800)).height(600)).title("OHLCChart03")).build();
        ((OHLCStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideS);
        ((OHLCStyler)chart.getStyler()).setLegendLayout(Styler.LegendLayout.Horizontal);
        ((OHLCStyler)chart.getStyler()).setToolTipsEnabled(true);
        ((OHLCStyler)chart.getStyler()).setYAxisDecimalPattern("##.00");
        ((OHLCStyler)chart.getStyler()).setToolTipsEnabled(true);
        ArrayList<Date> xData = new ArrayList<Date>();
        ArrayList<Double> openData = new ArrayList<Double>();
        ArrayList<Double> highData = new ArrayList<Double>();
        ArrayList<Double> lowData = new ArrayList<Double>();
        ArrayList<Double> closeData = new ArrayList<Double>();
        OHLCChart01.populateData(xData, openData, highData, lowData, closeData);
        ArrayList<Long> volumeData = new ArrayList<Long>();
        Random random = new Random();
        for (int i = 0; i < xData.size(); ++i) {
            volumeData.add(Long.valueOf(random.nextInt(100000)));
        }
        chart.addSeries("DAY K", xData, openData, highData, lowData, closeData, volumeData);
        chart.addSeries("MA5", xData, this.calculateMA(5, closeData));
        chart.addSeries("MA10", xData, this.calculateMA(10, closeData));
        chart.addSeries("MA15", xData, this.calculateMA(15, closeData));
        return chart;
    }

    private List<Double> calculateMA(int dayCount, List<Double> closeData) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < closeData.size(); ++i) {
            if (i < dayCount) {
                result.add(null);
                continue;
            }
            double sum = 0.0;
            for (int j = 0; j < dayCount; ++j) {
                sum += closeData.get(i - j).doubleValue();
            }
            result.add(sum / (double)dayCount);
        }
        return result;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Candle and lines";
    }
}

