/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.realtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.knowm.xchart.PieChart;
import org.knowm.xchart.PieChartBuilder;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.demo.charts.RealtimeExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;

public class RealtimeChart02
implements ExampleChart<PieChart>,
RealtimeExampleChart {
    private PieChart pieChart;

    public static void main(String[] args) {
        RealtimeChart02 realtimeChart01 = new RealtimeChart02();
        realtimeChart01.go();
    }

    private void go() {
        final SwingWrapper swingWrapper = new SwingWrapper((Chart)this.getChart());
        swingWrapper.displayChart();
        TimerTask chartUpdaterTask = new TimerTask(){

            @Override
            public void run() {
                RealtimeChart02.this.updateData();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        swingWrapper.repaintChart();
                    }
                });
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(chartUpdaterTask, 0L, 500L);
    }

    @Override
    public PieChart getChart() {
        this.pieChart = ((PieChartBuilder)((PieChartBuilder)((PieChartBuilder)((PieChartBuilder)new PieChartBuilder().width(500)).height(400)).theme(Styler.ChartTheme.Matlab)).title("Real-time Pie Chart")).build();
        ((PieStyler)this.pieChart.getStyler()).setLegendVisible(false);
        ((PieStyler)this.pieChart.getStyler()).setLabelType(PieStyler.LabelType.NameAndPercentage);
        ((PieStyler)this.pieChart.getStyler()).setLabelsDistance(1.22);
        ((PieStyler)this.pieChart.getStyler()).setPlotContentSize(0.7);
        ((PieStyler)this.pieChart.getStyler()).setDefaultSeriesRenderStyle(PieSeries.PieSeriesRenderStyle.Donut);
        Map<String, Number> pieData = this.getRandomData();
        for (Map.Entry<String, Number> entry : pieData.entrySet()) {
            this.pieChart.addSeries(entry.getKey(), entry.getValue());
        }
        return this.pieChart;
    }

    @Override
    public void updateData() {
        Map<String, Number> pieData = this.getRandomData();
        for (Map.Entry<String, Number> entry : pieData.entrySet()) {
            this.pieChart.updatePieSeries(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, Number> getRandomData() {
        HashMap<String, Number> pieData = new HashMap<String, Number>();
        pieData.put("A", Math.random() * 100.0);
        pieData.put("B", Math.random() * 100.0);
        pieData.put("C", Math.random() * 100.0);
        pieData.put("D", Math.random() * 100.0);
        pieData.put("E", Math.random() * 100.0);
        return pieData;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Real-time Pie Chart";
    }
}

