/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.standalone.readme;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class IntermediateExample {
    static final Random random = new Random();

    public static void main(String[] args) {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(500)).title("Gaussian Blobs")).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        ((XYStyler)chart.getStyler()).setChartTitleVisible(false);
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideSW);
        ((XYStyler)chart.getStyler()).setMarkerSize(16);
        chart.addSeries("Gaussian Blob 1", IntermediateExample.getGaussian(1000, 1.0, 10.0), IntermediateExample.getGaussian(1000, 1.0, 10.0));
        XYSeries series = chart.addSeries("Gaussian Blob 2", IntermediateExample.getGaussian(1000, 1.0, 10.0), IntermediateExample.getGaussian(1000, 0.0, 5.0));
        series.setMarker(SeriesMarkers.DIAMOND);
        new SwingWrapper((Chart)chart).displayChart();
    }

    private static List<Double> getGaussian(int number, double mean, double std) {
        LinkedList<Double> seriesData = new LinkedList<Double>();
        for (int i = 0; i < number; ++i) {
            seriesData.add(mean + std * random.nextGaussian());
        }
        return seriesData;
    }
}

