/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.ConstantExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.TagScript;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReallyStaticTagLibrary
extends TagLibrary {
    public static final TagLibrary INSTANCE = new ReallyStaticTagLibrary();
    public static boolean EMIT_LOCATION = false;
    private static final String[] SUFFIX = new String[]{"src/main/resources/", "src/test/resources/"};

    public Tag createTag(String name, Attributes attributes) throws JellyException {
        return null;
    }

    public TagScript createTagScript(String tagName, Attributes atts) throws JellyException {
        return ReallyStaticTagLibrary.createTagScript();
    }

    public static TagScript createTagScript() {
        return new TagScript(){
            private boolean allAttributesAreConstant = true;

            public void addAttribute(String name, Expression expression) {
                this.allAttributesAreConstant &= expression instanceof ConstantExpression;
                super.addAttribute(name, expression);
            }

            public void addAttribute(String name, String prefix, String nsURI, Expression expression) {
                this.allAttributesAreConstant &= expression instanceof ConstantExpression;
                super.addAttribute(name, prefix, nsURI, expression);
            }

            public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                Attributes actual = this.allAttributesAreConstant && !EMIT_LOCATION ? this.getSaxAttributes() : this.buildAttributes(context);
                try {
                    output.startElement(this.getNsUri(), this.getLocalName(), this.getElementName(), actual);
                    this.getTagBody().run(context, output);
                    output.endElement(this.getNsUri(), this.getLocalName(), this.getElementName());
                }
                catch (SAXException x) {
                    throw new JellyTagException((Throwable)x);
                }
            }

            private AttributesImpl buildAttributes(JellyContext context) {
                AttributesImpl actual = new AttributesImpl();
                for (String[] att : this.attributes.values()) {
                    Expression expression = att.exp;
                    String v = expression.evaluateAsString(context);
                    if (v == null) continue;
                    actual.addAttribute(att.nsURI, att.name, att.qname(), "CDATA", v);
                }
                if (EMIT_LOCATION) {
                    actual.addAttribute("", "file", "file", "CDATA", String.valueOf(this.getFileName()));
                    actual.addAttribute("", "line", "line", "CDATA", String.valueOf(this.getLineNumber()));
                    String form = this.getFileName().replace('\\', '/');
                    for (String suffix : SUFFIX) {
                        int idx = form.lastIndexOf(suffix);
                        if (idx <= 0) continue;
                        form = form.substring(idx + suffix.length());
                    }
                    int c = actual.getIndex("class");
                    if (c >= 0) {
                        actual.setValue(c, actual.getValue(c) + " " + form);
                    } else {
                        actual.addAttribute("", "class", "class", "CDATA", form);
                    }
                }
                return actual;
            }
        };
    }
}

