/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.autoencoder.demo;

import java.awt.Dimension;
import org.kramerlab.autoencoder.demo.ArffCompressionMain;
import org.kramerlab.autoencoder.math.matrix.Mat;
import org.kramerlab.autoencoder.math.matrix.Mat$;
import org.kramerlab.autoencoder.neuralnet.autoencoder.Autoencoder;
import org.kramerlab.autoencoder.thresholding.package$;
import org.kramerlab.autoencoder.visualization.TrainingObserver;
import org.kramerlab.autoencoder.visualization.VisualizableIntermediateResult;
import org.kramerlab.autoencoder.visualization.VisualizationComponent;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.swing.MainFrame;

public abstract class ArffCompressionMain$class {
    public static void main(ArffCompressionMain $this, String[] args) {
        Option option;
        block6: {
            block5: {
                block4: {
                    ObjectRef directoryPath = new ObjectRef((Object)None$.MODULE$);
                    Source$.MODULE$.fromFile($this.ExpectedConfigFilePath(), Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable($this, directoryPath){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef directoryPath$1;

                        public final void apply(String line) {
                            String trimmed = line.trim();
                            if (trimmed.startsWith("DATASETS_PATH")) {
                                this.directoryPath$1.elem = new Some((Object)trimmed.split("=")[1].trim());
                            }
                        }
                        {
                            this.directoryPath$1 = directoryPath$1;
                        }
                    });
                    if (Predef$.MODULE$.refArrayOps((Object[])args).size() > 0) {
                        directoryPath.elem = new Some((Object)args[0]);
                    }
                    boolean guiMode = !Predef$.MODULE$.refArrayOps((Object[])args).mkString(" ").contains("GUI_OFF");
                    option = (Option)directoryPath.elem;
                    if (!(option instanceof Some)) break block4;
                    $this.run((String)((Option)directoryPath.elem).get(), guiMode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Expected to find a configuration file with variable DATASETS_PATH in ").append((Object)$this.ExpectedConfigFilePath()).append((Object)" or ").append((Object)"path to the directory with datasets as first argument ").append((Object)"(ending with '/')").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public static void run(ArffCompressionMain $this, String inputDirectoryPath, boolean guiMode) {
        String inputFilePath = new StringBuilder().append((Object)inputDirectoryPath).append((Object)$this.fileName()).toString();
        Mat mat = $this.isSparse() ? org.kramerlab.autoencoder.wekacompatibility.package$.MODULE$.readSparseBooleanArff(inputFilePath) : org.kramerlab.autoencoder.wekacompatibility.package$.MODULE$.readDenseBooleanArff(inputFilePath);
        mat.shuffleRows();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Training data: ").append((Object)$this.fileName()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"dimensions: ").append((Object)BoxesRunTime.boxToInteger((int)mat.height())).append((Object)" x ").append((Object)BoxesRunTime.boxToInteger((int)mat.width())).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"number of ones: ").append((Object)BoxesRunTime.boxToDouble((double)mat.normSq())).toString());
        long startTime = System.currentTimeMillis();
        List<TrainingObserver> observers = $this.createObservers(guiMode);
        Autoencoder autoencoder = $this.createAutoencoder(mat, $this.numberOfHiddenLayers(), observers);
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"TIME FOR TRAINING: ").append((Object)BoxesRunTime.boxToLong((long)(totalTime / 60000L))).append((Object)" min").toString());
        Mat reconstruction = autoencoder.apply(mat);
        double error = reconstruction.$minus(mat).l2Norm();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"L2 Error: ").append((Object)BoxesRunTime.boxToDouble((double)error)).toString());
        double threshold = package$.MODULE$.findOptimalThreshold(reconstruction, mat);
        Mat binaryReconstruction = package$.MODULE$.binarize(reconstruction, threshold);
        Mat binaryDifference = binaryReconstruction.$minus(mat);
        double oneToZeroErrors = binaryDifference.filter((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$1) {
                return this.apply$mcZD$sp(x$1);
            }

            public boolean apply$mcZD$sp(double x$1) {
                return x$1 < 0.0;
            }
        }).normSq();
        double zeroToOneErrors = binaryDifference.filter((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$2) {
                return this.apply$mcZD$sp(x$2);
            }

            public boolean apply$mcZD$sp(double x$2) {
                return x$2 > 0.0;
            }
        }).normSq();
        double binaryError = binaryReconstruction.$minus(mat).normSq();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Total number of errors: ").append((Object)BoxesRunTime.boxToDouble((double)binaryError)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"0 -> 1 errors: ").append((Object)BoxesRunTime.boxToDouble((double)zeroToOneErrors)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"1 -> 0 errors: ").append((Object)BoxesRunTime.boxToDouble((double)oneToZeroErrors)).toString());
        int padding = 20;
        Mat finalResultMatrix = Mat$.MODULE$.empty(mat.height(), mat.width() * 2 + $this.compressionDimension() + 2 * padding, 0.0);
        int n = 0;
        int n2 = 0;
        finalResultMatrix.update(org.kramerlab.autoencoder.math.matrix.package$.MODULE$.end().$colon$colon$colon(n), org.kramerlab.autoencoder.math.matrix.package$.MODULE$.integerToConstantIndexSelector(mat.width()).$colon$colon$colon(n2), mat);
        int n3 = 0;
        int n4 = mat.width() + padding;
        finalResultMatrix.update(org.kramerlab.autoencoder.math.matrix.package$.MODULE$.end().$colon$colon$colon(n3), org.kramerlab.autoencoder.math.matrix.package$.MODULE$.integerToConstantIndexSelector(mat.width() + $this.compressionDimension() + padding).$colon$colon$colon(n4), autoencoder.compress(mat));
        int n5 = 0;
        int n6 = mat.width() + $this.compressionDimension() + 2 * padding;
        finalResultMatrix.update(org.kramerlab.autoencoder.math.matrix.package$.MODULE$.end().$colon$colon$colon(n5), org.kramerlab.autoencoder.math.matrix.package$.MODULE$.end().$colon$colon$colon(n6), binaryReconstruction);
        observers.foreach((Function1)new Serializable($this, finalResultMatrix){
            public static final long serialVersionUID = 0L;
            private final Mat finalResultMatrix$1;

            public final void apply(TrainingObserver obs) {
                obs.notify(new VisualizableIntermediateResult(this.finalResultMatrix$1), true);
            }
            {
                this.finalResultMatrix$1 = finalResultMatrix$1;
            }
        });
    }

    public static List createObservers(ArffCompressionMain $this, boolean guiMode) {
        Nil$ nil$;
        if (guiMode) {
            VisualizationComponent vis = new VisualizationComponent();
            MainFrame mainFrame = new MainFrame($this, vis){
                {
                    this.title_$eq("Autoencoder training progress");
                    this.contents_$eq(vis$1);
                }
            };
            mainFrame.size_$eq(new Dimension(400, 800));
            mainFrame.visible_$eq(true);
            nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VisualizationComponent[]{vis}));
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public static void $init$(ArffCompressionMain $this) {
        $this.org$kramerlab$autoencoder$demo$ArffCompressionMain$_setter_$ExpectedConfigFilePath_$eq("arffCompression.conf");
    }
}

