/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.autoencoder.demo;

import java.awt.Dimension;
import org.kramerlab.autoencoder.experiments.CrossValidation;
import org.kramerlab.autoencoder.experiments.ErrorMeasures$;
import org.kramerlab.autoencoder.math.matrix.Mat;
import org.kramerlab.autoencoder.neuralnet.autoencoder.Autoencoder;
import org.kramerlab.autoencoder.neuralnet.rbm.RbmTrainingStrategy;
import org.kramerlab.autoencoder.package$;
import org.kramerlab.autoencoder.visualization.TrainingObserver;
import org.kramerlab.autoencoder.visualization.VisualizationComponent;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.swing.MainFrame;

public final class ConfigurableCompressionMain$ {
    public static final ConfigurableCompressionMain$ MODULE$;

    static {
        new ConfigurableCompressionMain$();
    }

    public void main(String[] args) {
        ObjectRef fileName = new ObjectRef((Object)"NOT_SPECIFIED");
        IntRef compressionDimension = new IntRef(5);
        BooleanRef guiMode = new BooleanRef(false);
        IntRef hiddenLayers = new IntRef(2);
        IntRef folds = new IntRef(1);
        BooleanRef l2Error = new BooleanRef(false);
        ObjectRef strategy = new ObjectRef(package$.MODULE$.TournamentStrategy());
        ObjectRef strategyName = new ObjectRef((Object)"TournamentStrategy (default, not overridden)");
        Predef$.MODULE$.refArrayOps((Object[])args).foreach((Function1)new Serializable(fileName, compressionDimension, guiMode, hiddenLayers, folds, l2Error, strategy, strategyName){
            public static final long serialVersionUID = 0L;
            private final ObjectRef fileName$1;
            private final IntRef compressionDimension$1;
            private final BooleanRef guiMode$1;
            private final IntRef hiddenLayers$1;
            private final IntRef folds$1;
            private final BooleanRef l2Error$1;
            private final ObjectRef strategy$1;
            private final ObjectRef strategyName$1;

            public final void apply(String arg) {
                String string;
                block20: {
                    block14: {
                        BoxedUnit boxedUnit;
                        String string2;
                        String value;
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block13: {
                                                String[] keyValue = arg.split("=");
                                                String key = keyValue[0];
                                                value = keyValue[1];
                                                String string3 = string = key;
                                                if ("FILE" != null ? !"FILE".equals(string3) : string3 != null) break block13;
                                                this.fileName$1.elem = value;
                                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                                break block14;
                                            }
                                            String string4 = string;
                                            if ("COMPRESSION_DIMENSION" != null ? !"COMPRESSION_DIMENSION".equals(string4) : string4 != null) break block15;
                                            this.compressionDimension$1.elem = new StringOps(Predef$.MODULE$.augmentString(value)).toInt();
                                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                                            break block14;
                                        }
                                        String string5 = string;
                                        if ("GUI_MODE" != null ? !"GUI_MODE".equals(string5) : string5 != null) break block16;
                                        this.guiMode$1.elem = new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean();
                                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                                        break block14;
                                    }
                                    String string6 = string;
                                    if ("HIDDEN_LAYERS" != null ? !"HIDDEN_LAYERS".equals(string6) : string6 != null) break block17;
                                    this.hiddenLayers$1.elem = new StringOps(Predef$.MODULE$.augmentString(value)).toInt();
                                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                                    break block14;
                                }
                                String string7 = string;
                                if ("FOLDS" != null ? !"FOLDS".equals(string7) : string7 != null) break block18;
                                this.folds$1.elem = new StringOps(Predef$.MODULE$.augmentString(value)).toInt();
                                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                                break block14;
                            }
                            String string8 = string;
                            if ("L2ERROR" != null ? !"L2ERROR".equals(string8) : string8 != null) break block19;
                            this.l2Error$1.elem = new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean();
                            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                            break block14;
                        }
                        String string9 = string;
                        if ("STRATEGY" != null ? !"STRATEGY".equals(string9) : string9 != null) break block20;
                        boolean unknownStrategy = false;
                        String string10 = string2 = value;
                        if (!("Tournament" != null ? !"Tournament".equals(string10) : string10 != null)) {
                            this.strategy$1.elem = package$.MODULE$.TournamentStrategy();
                            BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                        } else {
                            String string11 = string2;
                            if (!("Hinton" != null ? !"Hinton".equals(string11) : string11 != null)) {
                                this.strategy$1.elem = package$.MODULE$.HintonsMiraculousStrategy();
                                BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                            } else {
                                String string12 = string2;
                                if (!("Random" != null ? !"Random".equals(string12) : string12 != null)) {
                                    this.strategy$1.elem = package$.MODULE$.RandomRetryStrategy();
                                    BoxedUnit boxedUnit10 = BoxedUnit.UNIT;
                                } else {
                                    String string13 = string2;
                                    if (!("None" != null ? !"None".equals(string13) : string13 != null)) {
                                        this.strategy$1.elem = package$.MODULE$.NoPretraining();
                                        BoxedUnit boxedUnit11 = BoxedUnit.UNIT;
                                    } else {
                                        unknownStrategy = true;
                                        BoxedUnit boxedUnit12 = BoxedUnit.UNIT;
                                    }
                                }
                            }
                        }
                        if (unknownStrategy) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.strategyName$1.elem = value;
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit13 = boxedUnit;
                    }
                    return;
                }
                throw new MatchError((Object)string);
            }
            {
                this.fileName$1 = fileName$1;
                this.compressionDimension$1 = compressionDimension$1;
                this.guiMode$1 = guiMode$1;
                this.hiddenLayers$1 = hiddenLayers$1;
                this.folds$1 = folds$1;
                this.l2Error$1 = l2Error$1;
                this.strategy$1 = strategy$1;
                this.strategyName$1 = strategyName$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"FILE: ").append((Object)((String)fileName.elem)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"COMPRESSION_DIMENSION: ").append((Object)BoxesRunTime.boxToInteger((int)compressionDimension.elem)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"GUI_MODE: ").append((Object)BoxesRunTime.boxToBoolean((boolean)guiMode.elem)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"HIDDEN_LAYERS: ").append((Object)BoxesRunTime.boxToInteger((int)hiddenLayers.elem)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"FOLDS: ").append((Object)BoxesRunTime.boxToInteger((int)folds.elem)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"L2ERROR: ").append((Object)BoxesRunTime.boxToBoolean((boolean)l2Error.elem)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"STRATEGY: ").append((Object)((String)strategyName.elem)).toString());
        Mat data = org.kramerlab.autoencoder.wekacompatibility.package$.MODULE$.readBooleanArff((String)fileName.elem);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"dimensions: ").append((Object)BoxesRunTime.boxToInteger((int)data.height())).append((Object)" x ").append((Object)BoxesRunTime.boxToInteger((int)data.width())).toString());
        int numberOfEntries = data.height() * data.width();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"number of entries: ").append((Object)BoxesRunTime.boxToInteger((int)numberOfEntries)).toString());
        double numberOfOnes = data.normSq();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"number of ones: ").append((Object)BoxesRunTime.boxToDouble((double)numberOfOnes)).toString());
        CrossValidation cv = new CrossValidation(data, folds.elem, new Serializable(compressionDimension, guiMode, hiddenLayers, l2Error, strategy){
            public static final long serialVersionUID = 0L;
            private final IntRef compressionDimension$1;
            private final BooleanRef guiMode$1;
            private final IntRef hiddenLayers$1;
            private final BooleanRef l2Error$1;
            private final ObjectRef strategy$1;

            public final Function1<Mat, Tuple2<Object, Object>> apply(Mat trainingSet) {
                Autoencoder autoencoder = ConfigurableCompressionMain$.MODULE$.createAutoencoder(trainingSet, this.compressionDimension$1.elem, this.hiddenLayers$1.elem, this.l2Error$1.elem, (Function0<RbmTrainingStrategy>)((Function0)this.strategy$1.elem), ConfigurableCompressionMain$.MODULE$.createObservers(this.guiMode$1.elem));
                Mat compression = autoencoder.compress(trainingSet);
                Mat reconstruction = autoencoder.decompress(compression);
                Mat thresholds = org.kramerlab.autoencoder.thresholding.package$.MODULE$.findOptimalColumnThresholds(reconstruction, trainingSet);
                return new Serializable(this, autoencoder, thresholds){
                    public static final long serialVersionUID = 0L;
                    private final Autoencoder autoencoder$1;
                    private final Mat thresholds$1;

                    public final Tuple2<Object, Object> apply(Mat testSet) {
                        Mat testCompression = this.autoencoder$1.compress(testSet);
                        Mat testDecompression = this.autoencoder$1.decompress(testCompression);
                        Mat testReconstruction = org.kramerlab.autoencoder.thresholding.package$.MODULE$.binarize(testDecompression, this.thresholds$1);
                        int err = ErrorMeasures$.MODULE$.reconstructionError(testSet, testReconstruction);
                        double aba = ErrorMeasures$.MODULE$.averageBalancedAccuracy(testSet, testReconstruction);
                        return new Tuple2.mcID.sp(err, aba);
                    }
                    {
                        this.autoencoder$1 = autoencoder$1;
                        this.thresholds$1 = thresholds$1;
                    }
                };
            }
            {
                this.compressionDimension$1 = compressionDimension$1;
                this.guiMode$1 = guiMode$1;
                this.hiddenLayers$1 = hiddenLayers$1;
                this.l2Error$1 = l2Error$1;
                this.strategy$1 = strategy$1;
            }
        });
        Seq cvResults = cv.apply();
        Tuple2 tuple2 = cvResults.unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq errors = (Seq)tuple2._1();
            Seq accuracies = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)errors, (Object)accuracies);
            Seq errors2 = (Seq)tuple23._1();
            Seq accuracies2 = (Seq)tuple23._2();
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Errors: ").append((Object)errors2).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Accuracies: ").append((Object)accuracies2).toString());
            double finalError = (double)BoxesRunTime.unboxToInt((Object)errors2.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (double)errors2.size();
            double finalAccuracy = BoxesRunTime.unboxToDouble((Object)accuracies2.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)accuracies2.size();
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Total error: ").append((Object)BoxesRunTime.boxToDouble((double)finalError)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Relative error: ").append((Object)BoxesRunTime.boxToDouble((double)(finalError / (double)numberOfEntries))).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Hamming loss: ").append((Object)BoxesRunTime.boxToDouble((double)(finalError / numberOfOnes))).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Average balanced accuracy: ").append((Object)BoxesRunTime.boxToDouble((double)finalAccuracy)).toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Autoencoder createAutoencoder(Mat data, int compressionDimension, int numberOfHiddenLayers, boolean l2Error, Function0<RbmTrainingStrategy> pretrainingStrategyFactory, List<TrainingObserver> obs) {
        return package$.MODULE$.trainAutoencoder(data, compressionDimension, numberOfHiddenLayers, l2Error, pretrainingStrategyFactory, obs);
    }

    public List<TrainingObserver> createObservers(boolean guiMode) {
        Nil$ nil$;
        if (guiMode) {
            VisualizationComponent vis = new VisualizationComponent();
            MainFrame mainFrame = new MainFrame(vis){
                {
                    this.title_$eq("Autoencoder training progress");
                    this.contents_$eq(vis$1);
                }
            };
            mainFrame.size_$eq(new Dimension(400, 800));
            mainFrame.visible_$eq(true);
            nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VisualizationComponent[]{vis}));
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private ConfigurableCompressionMain$() {
        MODULE$ = this;
    }
}

