/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.autoencoder.math.matrix;

import org.kramerlab.autoencoder.math.matrix.Mat;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Mat$
implements Serializable {
    public static final Mat$ MODULE$;

    static {
        new Mat$();
    }

    public Mat empty(int height, int width, double defaultValue) {
        return defaultValue == 0.0 ? new Mat(height, width, 0.0, (double[][])Array$.MODULE$.ofDim(height, width, ClassTag$.MODULE$.Double())) : new Mat(height, width, defaultValue, (double[][])Array$.MODULE$.fill(height, width, (Function0)new Serializable(defaultValue){
            public static final long serialVersionUID = 0L;
            private final double defaultValue$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.defaultValue$1;
            }
            {
                this.defaultValue$1 = defaultValue$1;
            }
        }, ClassTag$.MODULE$.Double()));
    }

    public Mat empty(int height, int width) {
        return this.empty(height, width, 0.0);
    }

    public Mat.MatInitializer apply(int height, int width, double defaultValue) {
        return new Mat.MatInitializer(height, width, defaultValue);
    }

    public Mat.MatInitializer apply(int height, int width) {
        return this.apply(height, width, 0.0);
    }

    public Mat createDirty(int height, int width, double defaultValue) {
        return new Mat(height, width, defaultValue, (double[][])Array$.MODULE$.ofDim(height, width, ClassTag$.MODULE$.Double()));
    }

    public Mat fill(int height, int width, double defaultValue, Function2<Object, Object, Object> f) {
        Mat result = this.createDirty(height, width, defaultValue);
        return result.mapWithIndex((Function3<Object, Object, Object, Object>)new Serializable(f){
            public static final long serialVersionUID = 0L;
            private final Function2 f$2;

            public final double apply(int i, int j, double x) {
                return this.f$2.apply$mcDII$sp(i, j);
            }
            {
                this.f$2 = f$2;
            }
        });
    }

    public Mat fill(int height, int width, Function2<Object, Object, Object> f) {
        return this.fill(height, width, 0.0, f);
    }

    public Mat fill(int height, int width, double defaultValue, double constant) {
        return new Mat(height, width, defaultValue, (double[][])Array$.MODULE$.fill(height, width, (Function0)new Serializable(constant){
            public static final long serialVersionUID = 0L;
            private final double constant$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.constant$1;
            }
            {
                this.constant$1 = constant$1;
            }
        }, ClassTag$.MODULE$.Double()));
    }

    public Mat ones(int height, int width) {
        return this.fill(height, width, 0.0, 1.0);
    }

    public Mat diag(Mat entries) {
        int n = package$.MODULE$.max(entries.width(), entries.height());
        return this.fill(n, n, 0.0, (Function2<Object, Object, Object>)new Serializable(entries){
            public static final long serialVersionUID = 0L;
            private final Mat entries$2;

            public final double apply(int i, int j) {
                return this.apply$mcDII$sp(i, j);
            }

            public double apply$mcDII$sp(int i, int j) {
                return i == j ? this.entries$2.apply(i) : 0.0;
            }
            {
                this.entries$2 = entries$2;
            }
        });
    }

    public Mat eye(int n) {
        return this.diag(this.fill(1, n, 0.0, 1.0));
    }

    public void requireSameDimensions(Mat a, Mat b, String operationDescription) {
        Tuple2<Object, Object> tuple2 = a.size();
        Tuple2<Object, Object> tuple22 = b.size();
        Predef$.MODULE$.require(!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null), (Function0)new Serializable(a, b, operationDescription){
            public static final long serialVersionUID = 0L;
            private final Mat a$1;
            private final Mat b$1;
            private final String operationDescription$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Matrix dimensions are incompatible. For ").append((Object)this.operationDescription$1).append((Object)" the dimensions must coincide, but are ").append(this.a$1.size()).append((Object)"!=").append(this.b$1.size()).toString();
            }
            {
                this.a$1 = a$1;
                this.b$1 = b$1;
                this.operationDescription$1 = operationDescription$1;
            }
        });
    }

    public void requireMultipliableDimensions(Mat a, Mat b) {
        Predef$.MODULE$.require(a.width() == b.height(), (Function0)new Serializable(a, b){
            public static final long serialVersionUID = 0L;
            private final Mat a$2;
            private final Mat b$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Matrix dimensions incompatible for multiplication. The width of the first matrix does not coincide with the height of the second matrix: ").append(this.a$2.size()).append((Object)" ").append(this.b$2.size()).toString();
            }
            {
                this.a$2 = a$2;
                this.b$2 = b$2;
            }
        });
    }

    public void main(String[] args) {
        Mat a = this.apply(2, 2).apply((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
        Mat b = this.apply(2, 3).apply((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0, 13.0, 19.0, 29.0, 33.0, 43.0}));
        Mat c = a.$bslash(b);
        Predef$.MODULE$.println((Object)c);
        Mat rnd = this.fill(8, 8, 0.0, (Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int i, int j) {
                return this.apply$mcDII$sp(i, j);
            }

            public double apply$mcDII$sp(int i, int j) {
                return package$.MODULE$.random() * (double)100;
            }
        });
        Mat rightSide = this.fill(8, 1, 0.0, (Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int i, int j) {
                return this.apply$mcDII$sp(i, j);
            }

            public double apply$mcDII$sp(int i, int j) {
                return package$.MODULE$.sin((double)i);
            }
        });
        Mat x = rnd.$bslash(rightSide);
        Mat reconstruction = rnd.$times(x);
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToDouble((double)rightSide.$minus(reconstruction).l2Norm()));
        int size = 8;
        Mat permutationSubject = this.fill(size, 1, 0.0, (Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int i, int j) {
                return this.apply$mcDII$sp(i, j);
            }

            public double apply$mcDII$sp(int i, int j) {
                return i;
            }
        });
        int[] permutation = org.kramerlab.autoencoder.math.random.package$.MODULE$.permutation(size);
        permutationSubject.permutateRows(permutation);
        Predef$.MODULE$.println((Object)Predef$.MODULE$.intArrayOps(permutation).mkString("[", ",", "]"));
        Predef$.MODULE$.println((Object)permutationSubject);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Mat$() {
        MODULE$ = this;
    }
}

