/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.autoencoder.mnist;

import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.FileInputStream;
import org.kramerlab.autoencoder.math.matrix.Mat;
import org.kramerlab.autoencoder.math.matrix.Mat$;
import org.kramerlab.autoencoder.mnist.MnistToMat$;
import org.kramerlab.autoencoder.visualization.package$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class MnistToMat$ {
    public static final MnistToMat$ MODULE$;

    static {
        new MnistToMat$();
    }

    public Mat loadMnistFile(String pathToFile, int maxImages) {
        DataInputStream reader = new DataInputStream(new FileInputStream(pathToFile));
        int magicNumber = reader.readInt();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"magic number: ").append((Object)BoxesRunTime.boxToInteger((int)magicNumber)).toString());
        int numImages = reader.readInt();
        int numRows = scala.math.package$.MODULE$.min(numImages, maxImages);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"number of images: ").append((Object)BoxesRunTime.boxToInteger((int)numImages)).toString());
        int imageWidth = reader.readInt();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"width: ").append((Object)BoxesRunTime.boxToInteger((int)imageWidth)).toString());
        int imageHeight = reader.readInt();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"height: ").append((Object)BoxesRunTime.boxToInteger((int)imageHeight)).toString());
        int numCols = imageWidth * imageHeight;
        Mat result = Mat$.MODULE$.empty(numRows, numCols);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)new Serializable(reader, numCols, result){
            public static final long serialVersionUID = 0L;
            private final DataInputStream reader$1;
            private final int numCols$1;
            public final Mat result$1;

            public final void apply(int r) {
                this.apply$mcVI$sp(r);
            }

            public void apply$mcVI$sp(int r) {
                byte[] buff = new byte[this.numCols$1];
                this.reader$1.read(buff);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numCols$1).foreach$mVc$sp((Function1)new Serializable(this, buff, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadMnistFile.1 $outer;
                    private final byte[] buff$1;
                    private final int r$1;

                    public final void apply(int c) {
                        this.apply$mcVI$sp(c);
                    }

                    public void apply$mcVI$sp(int c) {
                        this.$outer.result$1.update(this.r$1, c, (double)this.buff$1[c] / 255.0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.buff$1 = buff$1;
                        this.r$1 = r$1;
                    }
                });
            }
            {
                this.reader$1 = reader$1;
                this.numCols$1 = numCols$1;
                this.result$1 = result$1;
            }
        });
        reader.close();
        return result;
    }

    public int loadMnistFile$default$2() {
        return Integer.MAX_VALUE;
    }

    public BufferedImage rowToImage(Mat row, int height, int width) {
        return row.reshape(height, width).toImage((Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(double x) {
                return this.apply$mcID$sp(x);
            }

            public int apply$mcID$sp(double x) {
                int c = (int)((double)255 * (1.0 - x));
                return -16777216 + c * 65793;
            }
        });
    }

    public void main(String[] args) {
        Predef$.MODULE$.println((Object)"Showing example digits");
        String pathToMnistImageFile = "/home/tyukiand/Projects/autoencoder/train-images-idx3-ubyte";
        Mat data = this.loadMnistFile(pathToMnistImageFile, 100);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), data.height()).foreach$mVc$sp((Function1)new Serializable(data){
            public static final long serialVersionUID = 0L;
            private final Mat data$1;

            public final void apply(int r) {
                this.apply$mcVI$sp(r);
            }

            public void apply$mcVI$sp(int r) {
                int n = r;
                int n2 = 0;
                Mat row = this.data$1.apply(org.kramerlab.autoencoder.math.matrix.package$.MODULE$.integerToConstantIndexSelector(r + 1).$colon$colon$colon(n), org.kramerlab.autoencoder.math.matrix.package$.MODULE$.end().$colon$colon$colon(n2));
                BufferedImage img = MnistToMat$.MODULE$.rowToImage(row, 28, 28);
                package$.MODULE$.show(img, "example digit");
            }
            {
                this.data$1 = data$1;
            }
        });
    }

    private MnistToMat$() {
        MODULE$ = this;
    }
}

