/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.autoencoder.visualization;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.kramerlab.autoencoder.neuralnet.autoencoder.Autoencoder;
import org.kramerlab.autoencoder.neuralnet.rbm.Rbm;
import org.kramerlab.autoencoder.neuralnet.rbm.RbmStack;
import org.kramerlab.autoencoder.visualization.IntermediateTrainingResult;
import org.kramerlab.autoencoder.visualization.PartiallyTrainedAutoencoder;
import org.kramerlab.autoencoder.visualization.PartiallyTrainedRbm;
import org.kramerlab.autoencoder.visualization.PartiallyTrainedRbmStack;
import org.kramerlab.autoencoder.visualization.TrainingObserver;
import org.kramerlab.autoencoder.visualization.Visualizable;
import org.kramerlab.autoencoder.visualization.VisualizableIntermediateResult;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.swing.Component;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u0017\t1b+[:vC2L'0\u0019;j_:\u001cu.\u001c9p]\u0016tGO\u0003\u0002\u0004\t\u0005ia/[:vC2L'0\u0019;j_:T!!\u0002\u0004\u0002\u0017\u0005,Ho\\3oG>$WM\u001d\u0006\u0003\u000f!\t\u0011b\u001b:b[\u0016\u0014H.\u00192\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#A\u0003to&twMC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019bBA\u0005D_6\u0004xN\\3oiB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0011)J\f\u0017N\\5oO>\u00137/\u001a:wKJDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005U\u0001\u0001bB\u000f\u0001\u0005\u0004%\tAH\u0001\ng.L\u0007o\u0015;faN,\u0012a\b\t\u0003A\u0005j\u0011\u0001E\u0005\u0003EA\u00111!\u00138u\u0011\u0019!\u0003\u0001)A\u0005?\u0005Q1o[5q'R,\u0007o\u001d\u0011\t\u000f\u0019\u0002!\u0019!C\u0001=\u00051\u0012.\u001c9peR\fg\u000e^#wK:$8i\\8mI><h\u000e\u0003\u0004)\u0001\u0001\u0006IaH\u0001\u0018S6\u0004xN\u001d;b]R,e/\u001a8u\u0007>|G\u000eZ8x]\u0002BqA\u000b\u0001A\u0002\u0013\u0005a$A\tmCN$\u0018*\u001c9peR\fg\u000e^*uKBDq\u0001\f\u0001A\u0002\u0013\u0005Q&A\u000bmCN$\u0018*\u001c9peR\fg\u000e^*uKB|F%Z9\u0015\u00059\n\u0004C\u0001\u00110\u0013\t\u0001\u0004C\u0001\u0003V]&$\bb\u0002\u001a,\u0003\u0003\u0005\raH\u0001\u0004q\u0012\n\u0004B\u0002\u001b\u0001A\u0003&q$\u0001\nmCN$\u0018*\u001c9peR\fg\u000e^*uKB\u0004\u0003b\u0002\u001c\u0001\u0001\u0004%\tAH\u0001\fGV\u0014(/\u001a8u'R,\u0007\u000fC\u00049\u0001\u0001\u0007I\u0011A\u001d\u0002\u001f\r,(O]3oiN#X\r]0%KF$\"A\f\u001e\t\u000fI:\u0014\u0011!a\u0001?!1A\b\u0001Q!\n}\tAbY;se\u0016tGo\u0015;fa\u0002B\u0011B\u0010\u0001A\u0002\u0003\u0007I\u0011A \u0002\u0019\r,(O]3oi&k\u0017mZ3\u0016\u0003\u0001\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u0007\u0005<HOC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%!B%nC\u001e,\u0007\"C%\u0001\u0001\u0004\u0005\r\u0011\"\u0001K\u0003A\u0019WO\u001d:f]RLU.Y4f?\u0012*\u0017\u000f\u0006\u0002/\u0017\"9!\u0007SA\u0001\u0002\u0004\u0001\u0005BB'\u0001A\u0003&\u0001)A\u0007dkJ\u0014XM\u001c;J[\u0006<W\r\t\u0005\u0006\u001f\u0002!\t\u0005U\u0001\u0006a\u0006Lg\u000e\u001e\u000b\u0003]ECQA\u0015(A\u0002M\u000b\u0011a\u001a\t\u0003\u0003RK!!\u0016\"\u0003\u0015\u001d\u0013\u0018\r\u001d5jGN\u0014D\tC\u0003X\u0001\u0011\u0005\u0003,\u0001\u0004o_RLg-\u001f\u000b\u0004]es\u0006\"\u0002.W\u0001\u0004Y\u0016AE5oi\u0016\u0014X.\u001a3jCR,'+Z:vYR\u0004\"!\u0006/\n\u0005u\u0013!AG%oi\u0016\u0014X.\u001a3jCR,GK]1j]&twMU3tk2$\b\"B0W\u0001\u0004\u0001\u0017!C5na>\u0014H/\u00198u!\t\u0001\u0013-\u0003\u0002c!\t9!i\\8mK\u0006t\u0007")
public class VisualizationComponent
extends Component
implements TrainingObserver {
    private final int skipSteps;
    private final int importantEventCooldown;
    private int lastImportantStep = 0;
    private int currentStep = 0;
    private Image currentImage;

    public int skipSteps() {
        return this.skipSteps;
    }

    public int importantEventCooldown() {
        return this.importantEventCooldown;
    }

    public int lastImportantStep() {
        return this.lastImportantStep;
    }

    public void lastImportantStep_$eq(int x$1) {
        this.lastImportantStep = x$1;
    }

    public int currentStep() {
        return this.currentStep;
    }

    public void currentStep_$eq(int x$1) {
        this.currentStep = x$1;
    }

    public Image currentImage() {
        return this.currentImage;
    }

    public void currentImage_$eq(Image x$1) {
        this.currentImage = x$1;
    }

    public void paint(Graphics2D g) {
        Dimension dim = this.size();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(dim.getWidth(), dim.getHeight());
        if (sp2 != null) {
            Tuple2.mcDD.sp sp3;
            double w = sp2._1$mcD$sp();
            double h = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = sp3 = new Tuple2.mcDD.sp(w, h);
            double w2 = sp4._1$mcD$sp();
            double h2 = sp4._2$mcD$sp();
            g.drawImage(this.currentImage(), 0, 0, (int)w2, (int)h2, null);
            return;
        }
        throw new MatchError((Object)sp2);
    }

    @Override
    public void notify(IntermediateTrainingResult intermediateResult, boolean important) {
        if (important) {
            this.lastImportantStep_$eq(this.currentStep());
        }
        if (this.currentStep() % this.skipSteps() == 0 || this.currentStep() - this.lastImportantStep() < this.importantEventCooldown()) {
            BufferedImage bufferedImage;
            IntermediateTrainingResult intermediateTrainingResult = intermediateResult;
            if (intermediateTrainingResult instanceof PartiallyTrainedRbmStack) {
                PartiallyTrainedRbmStack partiallyTrainedRbmStack = (PartiallyTrainedRbmStack)intermediateTrainingResult;
                RbmStack stack = partiallyTrainedRbmStack.stack();
                bufferedImage = stack.toImage();
            } else if (intermediateTrainingResult instanceof PartiallyTrainedRbm) {
                PartiallyTrainedRbm partiallyTrainedRbm = (PartiallyTrainedRbm)intermediateTrainingResult;
                Rbm rbm = partiallyTrainedRbm.rbm();
                bufferedImage = rbm.toImage();
            } else if (intermediateTrainingResult instanceof PartiallyTrainedAutoencoder) {
                PartiallyTrainedAutoencoder partiallyTrainedAutoencoder = (PartiallyTrainedAutoencoder)intermediateTrainingResult;
                Autoencoder autoencoder = partiallyTrainedAutoencoder.autoencoder();
                bufferedImage = autoencoder.toImage();
            } else {
                if (!(intermediateTrainingResult instanceof VisualizableIntermediateResult)) {
                    throw new MatchError((Object)intermediateTrainingResult);
                }
                VisualizableIntermediateResult visualizableIntermediateResult = (VisualizableIntermediateResult)intermediateTrainingResult;
                Visualizable v = visualizableIntermediateResult.v();
                bufferedImage = v.toImage();
            }
            BufferedImage img = bufferedImage;
            this.currentImage_$eq(img);
            this.repaint();
        }
        this.currentStep_$eq(this.currentStep() + 1);
    }

    public VisualizationComponent() {
        this.skipSteps = 20;
        this.importantEventCooldown = 32;
    }
}

