/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;

public class RecursiveArgument
extends Argument {
    public static final int TYPE_ID_RECURSIVE = 102;
    public static final String TYPE_DESC_RECURSIVE = "User defined recursive argument";
    private List<Double> baseValues;
    private int recursiveCounter;
    private int startingIndex;

    public RecursiveArgument(String argumentName, String recursiveExpressionString, String indexName) {
        super(argumentName, recursiveExpressionString, new PrimitiveElement[0]);
        if (argumentName.equals(this.getArgumentName())) {
            this.argumentType = 3;
            this.baseValues = new ArrayList<Double>();
            this.n = new Argument(indexName, new PrimitiveElement[0]);
            this.argumentExpression.addArguments(this.n);
            this.argumentExpression.addArguments(this);
            this.argumentExpression.setDescription(argumentName);
            this.recursiveCounter = -1;
        }
    }

    public RecursiveArgument(String argumentName, String recursiveExpressionString, Argument n, PrimitiveElement ... elements) {
        super(argumentName, recursiveExpressionString, new PrimitiveElement[0]);
        if (argumentName.equals(this.getArgumentName())) {
            this.argumentType = 3;
            this.baseValues = new ArrayList<Double>();
            this.n = n;
            this.argumentExpression.addArguments(n);
            this.argumentExpression.addArguments(this);
            this.argumentExpression.addDefinitions(elements);
            this.argumentExpression.setDescription(argumentName);
            this.recursiveCounter = -1;
        }
    }

    public RecursiveArgument(String argumentDefinitionString, PrimitiveElement ... elements) {
        super(argumentDefinitionString, new PrimitiveElement[0]);
        if (mXparser.regexMatch(argumentDefinitionString, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            this.argumentType = 3;
            this.baseValues = new ArrayList<Double>();
            this.recursiveCounter = -1;
            this.argumentExpression.addArguments(this.n);
            this.argumentExpression.addArguments(this);
            this.argumentExpression.addDefinitions(elements);
            this.argumentExpression.setDescription(argumentDefinitionString);
        } else {
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
            this.argumentExpression.setSyntaxStatus(false, "[" + argumentDefinitionString + "] " + "Invalid argument definition (patterns: f(n) = f(n-1) ...  ).");
        }
    }

    public void addBaseCase(int index, double value) {
        int recSize = this.baseValues.size();
        if (index > recSize - 1) {
            for (int i = recSize; i < index; ++i) {
                this.baseValues.add(new Double(Double.NaN));
            }
            this.baseValues.add(new Double(value));
        } else {
            this.baseValues.set(index, new Double(value));
        }
    }

    public void resetAllCases() {
        this.baseValues.clear();
        this.recursiveCounter = -1;
    }

    public double getArgumentValue(double index) {
        if (this.recursiveCounter == -1) {
            this.startingIndex = (int)Math.round(index);
        }
        int recSize = this.baseValues.size();
        int idx = (int)Math.round(index);
        ++this.recursiveCounter;
        if (this.recursiveCounter <= this.startingIndex && idx <= this.startingIndex) {
            if (idx >= 0 && idx < recSize && !Double.isNaN(this.baseValues.get(idx))) {
                --this.recursiveCounter;
                return this.baseValues.get(idx);
            }
            if (idx >= 0) {
                this.n.setArgumentValue(idx);
                Expression newExp = new Expression(this.argumentExpression.expressionString, this.argumentExpression.argumentsList, this.argumentExpression.functionsList, this.argumentExpression.constantsList, true);
                newExp.setDescription(super.getArgumentName());
                if (super.getVerboseMode()) {
                    newExp.setVerboseMode();
                }
                double value = newExp.calculate();
                this.addBaseCase(idx, value);
                --this.recursiveCounter;
                return value;
            }
            --this.recursiveCounter;
            return Double.NaN;
        }
        --this.recursiveCounter;
        return Double.NaN;
    }
}

