/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.masukomi.aspirin.config.Configuration;
import org.masukomi.aspirin.delivery.DeliveryManager;
import org.masukomi.aspirin.listener.AspirinListener;
import org.masukomi.aspirin.listener.ListenerManager;
import org.slf4j.Logger;

public class AspirinInternal {
    public static final SimpleDateFormat expiryFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static volatile Session defaultSession = null;
    private static Integer idCounter = 0;
    private static Object idCounterLock = new Object();
    private static Configuration configuration = Configuration.getInstance();
    private static volatile ListenerManager listenerManager = null;
    private static volatile DeliveryManager deliveryManager = new DeliveryManager();

    public static Configuration getConfiguration() {
        return configuration;
    }

    protected static void add(MimeMessage msg) throws MessagingException {
        if (!deliveryManager.isAlive()) {
            deliveryManager.start();
        }
        deliveryManager.add(msg);
    }

    public static void add(MimeMessage msg, long expiry) throws MessagingException {
        if (0L < expiry) {
            AspirinInternal.setExpiry(msg, expiry);
        }
        AspirinInternal.add(msg);
    }

    public static void addListener(AspirinListener listener) {
        if (listenerManager == null) {
            listenerManager = new ListenerManager();
        }
        listenerManager.add(listener);
    }

    public static void remove(String mailid) throws MessagingException {
        deliveryManager.remove(mailid);
    }

    public static void removeListener(AspirinListener listener) {
        if (listenerManager != null) {
            listenerManager.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeMessage createNewMimeMessage() {
        if (defaultSession == null) {
            defaultSession = Session.getDefaultInstance((Properties)System.getProperties());
        }
        MimeMessage mMesg = new MimeMessage(defaultSession);
        Object object = idCounterLock;
        synchronized (object) {
            long nowTime = System.currentTimeMillis() / 1000L;
            Integer n = idCounter;
            Integer n2 = idCounter = Integer.valueOf(idCounter + 1);
            String newId = nowTime + "." + Integer.toHexString(n);
            try {
                mMesg.setHeader("X-Aspirin-MailID", newId);
            }
            catch (MessagingException msge) {
                AspirinInternal.getLogger().warn("Aspirin Mail ID could not be generated.", (Throwable)msge);
                msge.printStackTrace();
            }
        }
        return mMesg;
    }

    public static Collection<InternetAddress> extractRecipients(MimeMessage message) throws MessagingException {
        Message.RecipientType[] types;
        ArrayList<InternetAddress> recipients = new ArrayList<InternetAddress>();
        for (Message.RecipientType recType : types = new Message.RecipientType[]{MimeMessage.RecipientType.TO, MimeMessage.RecipientType.CC, MimeMessage.RecipientType.BCC}) {
            Address[] addresses = message.getRecipients(recType);
            if (addresses == null) continue;
            for (Address addr : addresses) {
                try {
                    recipients.add((InternetAddress)addr);
                }
                catch (Exception e) {
                    AspirinInternal.getLogger().warn("Recipient parsing failed.", (Throwable)e);
                }
            }
        }
        return recipients;
    }

    public static String formatExpiry(Date date) {
        return expiryFormat.format(date);
    }

    public static String getMailID(MimeMessage message) {
        try {
            String[] headers = message.getHeader("X-Aspirin-MailID");
            if (headers != null && 0 < headers.length) {
                return headers[0];
            }
        }
        catch (MessagingException e) {
            AspirinInternal.getLogger().error("MailID header could not be get from MimeMessage.", (Throwable)e);
        }
        return message.toString();
    }

    public static long getExpiry(MimeMessage message) {
        try {
            String[] headers = message.getHeader("X-Aspirin-Expiry");
            if (headers != null && 0 < headers.length) {
                return expiryFormat.parse(headers[0]).getTime();
            }
        }
        catch (Exception e) {
            AspirinInternal.getLogger().error("Expiration header could not be get from MimeMessage.", (Throwable)e);
        }
        if (configuration.getExpiry() == -1L) {
            return Long.MAX_VALUE;
        }
        try {
            Date sentDate = message.getReceivedDate();
            if (sentDate != null) {
                return sentDate.getTime() + configuration.getExpiry();
            }
        }
        catch (MessagingException e) {
            AspirinInternal.getLogger().error("Expiration calculation could not be based on message date.", (Throwable)e);
        }
        return System.currentTimeMillis() + configuration.getExpiry();
    }

    public static void setExpiry(MimeMessage message, long expiry) {
        try {
            message.setHeader("X-Aspirin-Expiry", expiryFormat.format(new Date(System.currentTimeMillis() + expiry)));
        }
        catch (MessagingException e) {
            AspirinInternal.getLogger().error("Could not set Expiry of the MimeMessage: " + AspirinInternal.getMailID(message) + ".", (Throwable)e);
        }
    }

    public static Logger getLogger() {
        if (configuration == null) {
            return null;
        }
        return configuration.getLogger();
    }

    public static DeliveryManager getDeliveryManager() {
        return deliveryManager;
    }

    public static ListenerManager getListenerManager() {
        return listenerManager;
    }

    public static void shutdown() {
        deliveryManager.shutdown();
    }
}

