/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.ParseException;
import org.masukomi.aspirin.AspirinInternal;
import org.masukomi.aspirin.config.ConfigurationChangeListener;
import org.masukomi.aspirin.config.ConfigurationMBean;
import org.masukomi.aspirin.store.mail.MailStore;
import org.masukomi.aspirin.store.mail.SimpleMailStore;
import org.masukomi.aspirin.store.queue.QueueStore;
import org.masukomi.aspirin.store.queue.SimpleQueueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements ConfigurationMBean {
    private static volatile Configuration instance;
    private Map<String, Object> configParameters = new HashMap<String, Object>();
    private static Logger log;
    private MailStore mailStore = null;
    private QueueStore queueStore = null;
    protected InternetAddress postmaster = null;
    private Session mailSession = null;
    private List<ConfigurationChangeListener> listeners;
    private Object listenerLock = new Object();
    private static final String MAIL_MIME_CHARSET = "mail.mime.charset";
    private static final String MAIL_SMTP_CONNECTIONTIMEOUT = "mail.smtp.connectiontimeout";
    private static final String MAIL_SMTP_HOST = "mail.smtp.host";
    private static final String MAIL_SMTP_LOCALHOST = "mail.smtp.localhost";
    private static final String MAIL_SMTP_TIMEOUT = "mail.smtp.timeout";

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public void init(Properties props) {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        parameterList.add(new Parameter("aspirin.delivery.attempt.count", 3, 1));
        parameterList.add(new Parameter("aspirin.delivery.attempt.delay", 300000, 1));
        parameterList.add(new Parameter("aspirin.delivery.bounce-on-failure", true, 3));
        parameterList.add(new Parameter("aspirin.delivery.debug", false, 3));
        parameterList.add(new Parameter("aspirin.delivery.expiry", -1L, 2));
        parameterList.add(new Parameter("aspirin.delivery.threads.active.max", 3, 1));
        parameterList.add(new Parameter("aspirin.delivery.threads.idle.max", 3, 1));
        parameterList.add(new Parameter("aspirin.delivery.timeout", 30000, 1));
        parameterList.add(new Parameter("aspirin.encoding", "UTF-8", 0));
        parameterList.add(new Parameter("aspirin.hostname", "localhost", 0));
        parameterList.add(new Parameter("aspirin.logger.name", "Aspirin", 0));
        parameterList.add(new Parameter("aspirin.logger.prefix", "Aspirin ", 0));
        parameterList.add(new Parameter("aspirin.mailstore.class", SimpleMailStore.class.getCanonicalName(), 0));
        parameterList.add(new Parameter("aspirin.postmaster.email", null, 0));
        parameterList.add(new Parameter("aspirin.queuestore.class", SimpleQueueStore.class.getCanonicalName(), 0));
        for (Parameter param : parameterList) {
            Object o = param.extractValue(props);
            if (o == null) continue;
            this.configParameters.put(param.getName(), o);
        }
        log = LoggerFactory.getLogger((String)((String)this.configParameters.get("aspirin.logger.name")));
        this.setPostmasterEmail((String)this.configParameters.get("aspirin.postmaster.email"));
        this.updateMailSession();
    }

    Configuration() {
        this.init(new Properties());
    }

    public InternetAddress getPostmaster() {
        return this.postmaster;
    }

    @Override
    public String getHostname() {
        return (String)this.configParameters.get("aspirin.hostname");
    }

    @Override
    public void setHostname(String hostname) {
        this.configParameters.put("aspirin.hostname", hostname);
        this.updateMailSession();
        this.notifyListeners("aspirin.hostname");
    }

    @Override
    public String getEncoding() {
        return (String)this.configParameters.get("aspirin.encoding");
    }

    @Override
    public void setEncoding(String encoding) {
        this.configParameters.put("aspirin.encoding", encoding);
        this.updateMailSession();
        this.notifyListeners("aspirin.encoding");
    }

    @Override
    public int getDeliveryAttemptCount() {
        return (Integer)this.configParameters.get("aspirin.delivery.attempt.count");
    }

    @Override
    public int getDeliveryAttemptDelay() {
        return (Integer)this.configParameters.get("aspirin.delivery.attempt.delay");
    }

    @Override
    public int getDeliveryThreadsActiveMax() {
        return (Integer)this.configParameters.get("aspirin.delivery.threads.active.max");
    }

    @Override
    public int getDeliveryThreadsIdleMax() {
        return (Integer)this.configParameters.get("aspirin.delivery.threads.idle.max");
    }

    @Override
    public int getDeliveryTimeout() {
        return (Integer)this.configParameters.get("aspirin.delivery.timeout");
    }

    @Override
    public long getExpiry() {
        return (Long)this.configParameters.get("aspirin.delivery.expiry");
    }

    @Override
    public String getLoggerName() {
        return (String)this.configParameters.get("aspirin.logger.name");
    }

    @Override
    public String getLoggerPrefix() {
        return (String)this.configParameters.get("aspirin.logger.prefix");
    }

    public MailStore getMailStore() {
        if (this.mailStore == null) {
            String mailStoreClassName = (String)this.configParameters.get("aspirin.mailstore.class");
            try {
                Class<?> storeClass = Class.forName(mailStoreClassName);
                if (storeClass.getInterfaces()[0].equals(MailStore.class)) {
                    this.mailStore = (MailStore)storeClass.newInstance();
                }
            }
            catch (Exception e) {
                log.error(this.getClass().getSimpleName() + " Mail store class could not be instantiated. Class=" + mailStoreClassName, (Throwable)e);
                this.mailStore = new SimpleMailStore();
            }
        }
        return this.mailStore;
    }

    @Override
    public String getPostmasterEmail() {
        return this.postmaster.toString();
    }

    public QueueStore getQueueStore() {
        if (this.queueStore == null) {
            String queueStoreClassName = (String)this.configParameters.get("aspirin.queuestore.class");
            try {
                Class<?> storeClass = Class.forName(queueStoreClassName);
                if (storeClass.getInterfaces()[0].equals(QueueStore.class)) {
                    this.queueStore = (QueueStore)storeClass.newInstance();
                }
            }
            catch (Exception e) {
                log.error(this.getClass().getSimpleName() + " Queue store class could not be instantiated. Class=" + queueStoreClassName, (Throwable)e);
                this.queueStore = new SimpleQueueStore();
            }
        }
        return this.queueStore;
    }

    @Override
    public boolean isDeliveryBounceOnFailure() {
        return (Boolean)this.configParameters.get("aspirin.delivery.bounce-on-failure");
    }

    @Override
    public boolean isDeliveryDebug() {
        return (Boolean)this.configParameters.get("aspirin.delivery.debug");
    }

    @Override
    public void setDeliveryAttemptCount(int attemptCount) {
        this.configParameters.put("aspirin.delivery.attempt.count", attemptCount);
        this.notifyListeners("aspirin.delivery.attempt.count");
    }

    @Override
    public void setDeliveryAttemptDelay(int delay) {
        this.configParameters.put("aspirin.delivery.attempt.delay", delay);
        this.notifyListeners("aspirin.delivery.attempt.delay");
    }

    @Override
    public void setDeliveryBounceOnFailure(boolean bounce) {
        this.configParameters.put("aspirin.delivery.bounce-on-failure", bounce);
        this.notifyListeners("aspirin.delivery.bounce-on-failure");
    }

    @Override
    public void setDeliveryDebug(boolean debug) {
        this.configParameters.put("aspirin.delivery.debug", debug);
        this.updateMailSession();
        this.notifyListeners("aspirin.delivery.debug");
    }

    @Override
    public void setDeliveryThreadsActiveMax(int activeThreadsMax) {
        this.configParameters.put("aspirin.delivery.threads.active.max", activeThreadsMax);
        this.notifyListeners("aspirin.delivery.threads.active.max");
    }

    @Override
    public void setDeliveryThreadsIdleMax(int idleThreadsMax) {
        this.configParameters.put("aspirin.delivery.threads.idle.max", idleThreadsMax);
        this.notifyListeners("aspirin.delivery.threads.idle.max");
    }

    @Override
    public void setDeliveryTimeout(int timeout) {
        this.configParameters.put("aspirin.delivery.timeout", timeout);
        this.updateMailSession();
        this.notifyListeners("aspirin.delivery.timeout");
    }

    @Override
    public void setExpiry(long expiry) {
        this.configParameters.put("aspirin.delivery.expiry", expiry);
        this.notifyListeners("aspirin.delivery.expiry");
    }

    @Override
    public void setLoggerName(String loggerName) {
        this.configParameters.put("aspirin.logger.name", loggerName);
        log = LoggerFactory.getLogger((String)loggerName);
        this.notifyListeners("aspirin.logger.name");
    }

    @Override
    public void setLoggerPrefix(String loggerPrefix) {
        this.configParameters.put("aspirin.logger.prefix", loggerPrefix);
        this.notifyListeners("aspirin.logger.prefix");
    }

    public void setMailStore(MailStore mailStore) {
        this.mailStore = mailStore;
        this.notifyListeners("aspirin.mailstore.class");
    }

    @Override
    public void setPostmasterEmail(String emailAddress) {
        if (emailAddress == null) {
            this.postmaster = null;
            return;
        }
        try {
            this.postmaster = new InternetAddress(emailAddress);
            this.notifyListeners("aspirin.postmaster.email");
        }
        catch (ParseException e) {
            log.error(this.getClass().getSimpleName() + ".setPostmasterEmail(): The email address is unparseable.", (Throwable)e);
        }
    }

    public void setQueueStore(QueueStore queueStore) {
        this.queueStore = queueStore;
        this.notifyListeners("aspirin.queuestore.class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigurationChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ConfigurationChangeListener>();
        }
        Object object = this.listenerLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigurationChangeListener listener) {
        if (this.listeners != null) {
            Object object = this.listenerLock;
            synchronized (object) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String changedParameterName) {
        if (this.listeners != null && 0 < this.listeners.size()) {
            if (log.isInfoEnabled()) {
                log.info(this.getClass().getSimpleName() + ".notifyListeners(): Configuration parameter '" + changedParameterName + "' changed.");
            }
            Object object = this.listenerLock;
            synchronized (object) {
                for (ConfigurationChangeListener listener : this.listeners) {
                    listener.configChanged(changedParameterName);
                }
            }
        }
    }

    @Override
    public String getMailStoreClassName() {
        return (String)this.configParameters.get("aspirin.mailstore.class");
    }

    @Override
    public void setMailStoreClassName(String className) {
        this.configParameters.put("aspirin.mailstore.class", className);
        this.mailStore = null;
        this.notifyListeners("aspirin.mailstore.class");
    }

    @Override
    public String getQueueStoreClassName() {
        return (String)this.configParameters.get("aspirin.queuestore.class");
    }

    @Override
    public void setQueueStoreClassName(String className) {
        this.configParameters.put("aspirin.queuestore.class", className);
        this.queueStore = null;
        this.notifyListeners("aspirin.queuestore.class");
    }

    public Logger getLogger() {
        return LoggerFactory.getLogger((String)((String)this.configParameters.get("aspirin.logger.prefix")));
    }

    public Session getMailSession() {
        return Session.getInstance((Properties)this.mailSession.getProperties());
    }

    public Object getProperty(String name) {
        return this.configParameters.get(name);
    }

    public void setProperty(String name, Object value) {
        this.configParameters.put(name, value);
    }

    private void updateMailSession() {
        Properties mailSessionProps = System.getProperties();
        mailSessionProps.put(MAIL_SMTP_HOST, this.getHostname());
        mailSessionProps.put(MAIL_SMTP_LOCALHOST, this.getHostname());
        mailSessionProps.put(MAIL_MIME_CHARSET, this.getEncoding());
        mailSessionProps.put(MAIL_SMTP_CONNECTIONTIMEOUT, (Object)this.getDeliveryTimeout());
        mailSessionProps.put(MAIL_SMTP_TIMEOUT, (Object)this.getDeliveryTimeout());
        Session newSession = Session.getInstance((Properties)mailSessionProps);
        if ((AspirinInternal.getLogger() == null || AspirinInternal.getLogger().isDebugEnabled()) && this.isDeliveryDebug()) {
            newSession.setDebug(true);
        }
        this.mailSession = newSession;
    }

    static {
        log = null;
    }

    private class Parameter {
        public static final int TYPE_STRING = 0;
        public static final int TYPE_INTEGER = 1;
        public static final int TYPE_LONG = 2;
        public static final int TYPE_BOOLEAN = 3;
        private String name;
        private int type;
        private Object defaultValue;

        public Parameter(String name, Object defaultValue, int type) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        Object extractValue(Properties props) {
            String tempString = props.getProperty(this.name);
            if (tempString == null) {
                tempString = System.getProperty(this.name);
            }
            if (tempString != null) {
                switch (this.type) {
                    case 1: {
                        return Integer.valueOf(tempString);
                    }
                    case 2: {
                        return Long.valueOf(tempString);
                    }
                    case 3: {
                        return "true".equalsIgnoreCase(tempString) ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
                return tempString;
            }
            return this.defaultValue;
        }
    }
}

