/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.delivery;

import java.util.List;
import org.masukomi.aspirin.AspirinInternal;
import org.masukomi.aspirin.store.mail.MailStore;
import org.masukomi.aspirin.store.queue.QueueStore;

public class DeliveryMaintenanceThread
extends Thread {
    private boolean running = false;

    public DeliveryMaintenanceThread() {
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AspirinInternal.getLogger().info("Maintenance thread started.");
        this.running = true;
        while (this.running) {
            try {
                DeliveryMaintenanceThread deliveryMaintenanceThread = this;
                synchronized (deliveryMaintenanceThread) {
                    this.wait(3600000L);
                }
            }
            catch (InterruptedException ie) {
                this.running = false;
                AspirinInternal.getLogger().info("Maintenance thread goes down.");
            }
            try {
                QueueStore queueStore = AspirinInternal.getConfiguration().getQueueStore();
                MailStore mailStore = AspirinInternal.getConfiguration().getMailStore();
                List<String> usedMailIds = queueStore.clean();
                List<String> mailStoreMailIds = mailStore.getMailIds();
                AspirinInternal.getLogger().debug("Maintenance running: usedMailIds: {}, mailStoreMailIds: {}.", new Object[]{usedMailIds.size(), mailStoreMailIds.size()});
                if (!mailStoreMailIds.removeAll(usedMailIds)) continue;
                for (String unusedMailId : mailStoreMailIds) {
                    mailStore.remove(unusedMailId);
                }
            }
            catch (Exception e) {
                AspirinInternal.getLogger().error("Maintenance failed.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        DeliveryMaintenanceThread deliveryMaintenanceThread = this;
        synchronized (deliveryMaintenanceThread) {
            this.notify();
        }
    }
}

