/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.delivery;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.masukomi.aspirin.AspirinInternal;
import org.masukomi.aspirin.config.ConfigurationChangeListener;
import org.masukomi.aspirin.delivery.DeliveryContext;
import org.masukomi.aspirin.delivery.DeliveryHandler;
import org.masukomi.aspirin.delivery.DeliveryMaintenanceThread;
import org.masukomi.aspirin.delivery.DeliveryThread;
import org.masukomi.aspirin.delivery.GenericPoolableDeliveryThreadFactory;
import org.masukomi.aspirin.delivery.SendMessage;
import org.masukomi.aspirin.dns.ResolveHost;
import org.masukomi.aspirin.store.mail.MailStore;
import org.masukomi.aspirin.store.queue.DeliveryState;
import org.masukomi.aspirin.store.queue.QueueInfo;
import org.masukomi.aspirin.store.queue.QueueStore;

public final class DeliveryManager
extends Thread
implements ConfigurationChangeListener {
    private MailStore mailStore;
    private QueueStore queueStore;
    private DeliveryMaintenanceThread maintenanceThread;
    private Object mailingLock = new Object();
    private ObjectPool deliveryThreadObjectPool = null;
    private boolean running = false;
    private GenericPoolableDeliveryThreadFactory deliveryThreadObjectFactory = null;
    private Map<String, DeliveryHandler> deliveryHandlers = new HashMap<String, DeliveryHandler>();

    public DeliveryManager() {
        this.setName("Aspirin-" + this.getClass().getSimpleName() + "-" + this.getId());
        GenericObjectPool.Config gopConf = new GenericObjectPool.Config();
        gopConf.lifo = false;
        gopConf.maxActive = AspirinInternal.getConfiguration().getDeliveryThreadsActiveMax();
        gopConf.maxIdle = AspirinInternal.getConfiguration().getDeliveryThreadsIdleMax();
        gopConf.maxWait = 5000L;
        gopConf.testOnReturn = true;
        gopConf.whenExhaustedAction = 1;
        this.deliveryThreadObjectFactory = new GenericPoolableDeliveryThreadFactory();
        this.deliveryThreadObjectPool = new GenericObjectPool((PoolableObjectFactory)this.deliveryThreadObjectFactory, gopConf);
        this.deliveryThreadObjectFactory.init(new ThreadGroup("DeliveryThreadGroup"), this.deliveryThreadObjectPool);
        this.queueStore = AspirinInternal.getConfiguration().getQueueStore();
        this.queueStore.init();
        this.mailStore = AspirinInternal.getConfiguration().getMailStore();
        this.mailStore.init();
        this.maintenanceThread = new DeliveryMaintenanceThread();
        this.maintenanceThread.start();
        this.deliveryHandlers.put(SendMessage.class.getCanonicalName(), new SendMessage());
        this.deliveryHandlers.put(ResolveHost.class.getCanonicalName(), new ResolveHost());
        AspirinInternal.getConfiguration().addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(MimeMessage mimeMessage) throws MessagingException {
        String mailid = AspirinInternal.getMailID(mimeMessage);
        long expiry = AspirinInternal.getExpiry(mimeMessage);
        Collection<InternetAddress> recipients = AspirinInternal.extractRecipients(mimeMessage);
        Object object = this.mailingLock;
        synchronized (object) {
            this.mailStore.set(mailid, mimeMessage);
            this.queueStore.add(mailid, expiry, recipients);
        }
        return mailid;
    }

    public MimeMessage get(QueueInfo qi) {
        return this.mailStore.get(qi.getMailid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String messageName) {
        Object object = this.mailingLock;
        synchronized (object) {
            this.mailStore.remove(messageName);
            this.queueStore.remove(messageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        AspirinInternal.getLogger().info("DeliveryManager started.");
        while (this.running) {
            QueueInfo qi = null;
            try {
                Object message;
                qi = this.queueStore.next();
                if (qi != null) {
                    message = this.get(qi);
                    if (message == null) {
                        AspirinInternal.getLogger().warn("No MimeMessage found for qi={}", (Object)qi);
                        qi.setResultInfo("No MimeMessage found.");
                        qi.setState(DeliveryState.FAILED);
                        this.release(qi);
                        continue;
                    }
                    DeliveryContext dCtx = new DeliveryContext().setQueueInfo(qi).setMessage((MimeMessage)message);
                    AspirinInternal.getLogger().trace("DeliveryManager.run(): Pool state. A{}/I{}", new Object[]{this.deliveryThreadObjectPool.getNumActive(), this.deliveryThreadObjectPool.getNumIdle()});
                    try {
                        AspirinInternal.getLogger().debug("DeliveryManager.run(): Start delivery. qi={}", (Object)qi);
                        DeliveryThread dThread = (DeliveryThread)this.deliveryThreadObjectPool.borrowObject();
                        AspirinInternal.getLogger().trace("DeliveryManager.run(): Borrow DeliveryThread object. dt={}: state '{}/{}'", new Object[]{dThread.getName(), dThread.getState().name(), dThread.isAlive()});
                        dThread.setContext(dCtx);
                        if (dThread.isAlive()) continue;
                        dThread.start();
                    }
                    catch (IllegalStateException ise) {
                        this.release(qi);
                    }
                    catch (NoSuchElementException nsee) {
                        AspirinInternal.getLogger().debug("DeliveryManager.run(): No idle DeliveryThread is available: {}", (Object)nsee.getMessage());
                        this.release(qi);
                    }
                    catch (Exception e) {
                        AspirinInternal.getLogger().error("DeliveryManager.run(): Failed borrow delivery thread object.", (Throwable)e);
                        this.release(qi);
                    }
                    continue;
                }
                if (AspirinInternal.getLogger().isTraceEnabled() && 0 < this.queueStore.size()) {
                    AspirinInternal.getLogger().trace("DeliveryManager.run(): There is no sendable item in the queue. Fallback to waiting state for a minute.");
                }
                message = this;
                synchronized (message) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException e) {
                        this.running = false;
                    }
                }
            }
            catch (Throwable t) {
                if (qi == null) continue;
                this.release(qi);
            }
        }
        AspirinInternal.getLogger().info("DeliveryManager terminated.");
    }

    public boolean isRunning() {
        return this.running;
    }

    public void terminate() {
        this.running = false;
    }

    public void release(QueueInfo qi) {
        if (qi.hasState(DeliveryState.IN_PROGRESS)) {
            if (qi.isInTimeBounds()) {
                qi.setState(DeliveryState.QUEUED);
                AspirinInternal.getLogger().trace("DeliveryManager.release(): Releasing: QUEUED. qi={}", (Object)qi);
            } else {
                qi.setState(DeliveryState.FAILED);
                AspirinInternal.getLogger().trace("DeliveryManager.release(): Releasing: FAILED. qi={}", (Object)qi);
            }
        }
        this.queueStore.setSendingResult(qi);
        if (this.queueStore.isCompleted(qi.getMailid())) {
            this.queueStore.remove(qi.getMailid());
        }
        AspirinInternal.getLogger().trace("DeliveryManager.release(): Release item '{}' with state: '{}' after {} attempts.", new Object[]{qi.getMailid(), qi.getState().name(), qi.getAttemptCount()});
    }

    public boolean isCompleted(QueueInfo qi) {
        return this.queueStore.isCompleted(qi.getMailid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configChanged(String parameterName) {
        Object object = this.mailingLock;
        synchronized (object) {
            if (parameterName.equals("aspirin.mailstore.class")) {
                this.mailStore = AspirinInternal.getConfiguration().getMailStore();
            } else if (parameterName.equals("aspirin.queuestore.class")) {
                this.queueStore = AspirinInternal.getConfiguration().getQueueStore();
            }
            if (parameterName.equals("aspirin.delivery.threads.active.max")) {
                ((GenericObjectPool)this.deliveryThreadObjectPool).setMaxActive(AspirinInternal.getConfiguration().getDeliveryThreadsActiveMax());
            } else if (parameterName.equals("aspirin.delivery.threads.idle.max")) {
                ((GenericObjectPool)this.deliveryThreadObjectPool).setMaxIdle(AspirinInternal.getConfiguration().getDeliveryThreadsIdleMax());
            }
        }
    }

    public DeliveryHandler getDeliveryHandler(String handlerName) {
        return this.deliveryHandlers.get(handlerName);
    }

    public void shutdown() {
        this.running = false;
        try {
            this.deliveryThreadObjectPool.close();
            this.deliveryThreadObjectPool.clear();
        }
        catch (Exception e) {
            AspirinInternal.getLogger().error("DeliveryManager.shutdown() failed.", (Throwable)e);
        }
        this.maintenanceThread.shutdown();
    }
}

