/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.delivery;

import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.commons.pool.ObjectPool;
import org.masukomi.aspirin.AspirinInternal;
import org.masukomi.aspirin.delivery.DeliveryContext;
import org.masukomi.aspirin.delivery.DeliveryException;
import org.masukomi.aspirin.delivery.SendMessage;
import org.masukomi.aspirin.dns.ResolveHost;
import org.masukomi.aspirin.store.queue.DeliveryState;
import org.masukomi.aspirin.store.queue.QueueInfo;

public class DeliveryThread
extends Thread {
    private boolean running = true;
    private ObjectPool parentObjectPool = null;
    private DeliveryContext dCtx = null;

    DeliveryThread(ThreadGroup parentThreadGroup) {
        super(parentThreadGroup, DeliveryThread.class.getSimpleName());
    }

    public ObjectPool getParentObjectPool() {
        return this.parentObjectPool;
    }

    public void setParentObjectPool(ObjectPool parentObjectPool) {
        this.parentObjectPool = parentObjectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AspirinInternal.getLogger().debug("DeliveryThread ({}).shutdown(): Called.", (Object)this.getName());
        this.running = false;
        DeliveryThread deliveryThread = this;
        synchronized (deliveryThread) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            DeliveryThread deliveryThread = this;
            synchronized (deliveryThread) {
                if (this.dCtx == null) {
                    try {
                        if (this.running) {
                            AspirinInternal.getLogger().trace("DeliveryThread ({}).run(): Wait for next sendable item.", (Object)this.getName());
                            this.wait(60000L);
                            continue;
                        }
                    }
                    catch (InterruptedException ie) {
                        if (this.dCtx != null) {
                            AspirinInternal.getLogger().trace("DeliveryThread ({}).run(): Release item after interruption. qi={}", new Object[]{this.getName(), this.dCtx});
                            AspirinInternal.getDeliveryManager().release(this.dCtx.getQueueInfo());
                            this.dCtx = null;
                        }
                        this.running = false;
                        try {
                            AspirinInternal.getLogger().trace("DeliveryThread ({}).run(): Invalidate DeliveryThread object in the pool.", (Object)this.getName());
                            this.parentObjectPool.invalidateObject((Object)this);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("The object could not be invalidated in the pool.", e);
                        }
                    }
                }
            }
            try {
                if (this.dCtx != null) {
                    AspirinInternal.getLogger().trace("DeliveryThread ({}).run(): Call delivering... dCtx={}", new Object[]{this.getName(), this.dCtx});
                    this.deliver(this.dCtx, AspirinInternal.getConfiguration().getMailSession());
                    AspirinInternal.getDeliveryManager().release(this.dCtx.getQueueInfo());
                    this.dCtx = null;
                }
            }
            catch (Exception e) {
                AspirinInternal.getLogger().error("DeliveryThread (" + this.getName() + ").run(): Could not deliver message. dCtx={" + this.dCtx + "}", (Throwable)e);
            }
            finally {
                if (this.dCtx != null && !this.dCtx.getQueueInfo().isSendable()) {
                    AspirinInternal.getDeliveryManager().release(this.dCtx.getQueueInfo());
                    this.dCtx = null;
                }
            }
            if (this.dCtx != null) continue;
            try {
                AspirinInternal.getLogger().trace("DeliveryThread ({}).run(): Try to give back DeliveryThread object into the pool.", (Object)this.getName());
                this.parentObjectPool.returnObject((Object)this);
            }
            catch (Exception e) {
                AspirinInternal.getLogger().error("DeliveryThread (" + this.getName() + ").run(): The object could not be returned into the pool.", (Throwable)e);
                this.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(DeliveryContext dCtx) throws MessagingException {
        DeliveryThread deliveryThread = this;
        synchronized (deliveryThread) {
            if (this.dCtx != null) {
                if (this.dCtx.getQueueInfo().hasState(DeliveryState.IN_PROGRESS)) {
                    this.notify();
                }
                throw new MessagingException("The previous QuedItem was not removed from this thread.");
            }
            this.dCtx = dCtx;
            AspirinInternal.getLogger().trace("DeliveryThread ({}).setQuedItem(): Item was set. qi={}", new Object[]{this.getName(), dCtx});
            this.notify();
        }
    }

    private void deliver(DeliveryContext dCtx, Session session) {
        AspirinInternal.getLogger().info("DeliveryThread ({}).deliver(): Starting mail delivery. qi={}", new Object[]{this.getName(), dCtx});
        String[] handlerList = new String[]{ResolveHost.class.getCanonicalName(), SendMessage.class.getCanonicalName()};
        QueueInfo qInfo = dCtx.getQueueInfo();
        for (String handlerName : handlerList) {
            try {
                AspirinInternal.getDeliveryManager().getDeliveryHandler(handlerName).handle(dCtx);
            }
            catch (DeliveryException de) {
                qInfo.setResultInfo(de.getMessage());
                AspirinInternal.getLogger().info("DeliveryThread ({}).deliver(): Mail delivery failed: {}. qi={}", new Object[]{this.getName(), qInfo.getResultInfo(), dCtx});
                if (de.isPermanent()) {
                    qInfo.setState(DeliveryState.FAILED);
                } else {
                    qInfo.setState(DeliveryState.QUEUED);
                }
                return;
            }
        }
        if (qInfo.hasState(DeliveryState.IN_PROGRESS)) {
            if (qInfo.getResultInfo() == null) {
                qInfo.setResultInfo("250 OK");
            }
            AspirinInternal.getLogger().info("DeliveryThread ({}).deliver(): Mail delivery success: {}. qi={}", new Object[]{this.getName(), qInfo.getResultInfo(), dCtx});
            qInfo.setState(DeliveryState.SENT);
        }
    }
}

