/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.delivery;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.masukomi.aspirin.AspirinInternal;
import org.masukomi.aspirin.delivery.DeliveryThread;

public class GenericPoolableDeliveryThreadFactory
extends BasePoolableObjectFactory {
    private ThreadGroup deliveryThreadGroup = null;
    private ObjectPool myParentPool = null;
    private Integer rdCount = 0;
    private Object rdLock = new Object();

    public void init(ThreadGroup deliveryThreadGroup, ObjectPool pool) {
        this.deliveryThreadGroup = deliveryThreadGroup;
        this.myParentPool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeObject() throws Exception {
        if (this.myParentPool == null) {
            throw new RuntimeException("Please set the parent pool for right working.");
        }
        DeliveryThread dThread = new DeliveryThread(this.deliveryThreadGroup);
        Object object = this.rdLock;
        synchronized (object) {
            Integer n = this.rdCount;
            Integer n2 = this.rdCount = Integer.valueOf(this.rdCount + 1);
            dThread.setName(DeliveryThread.class.getSimpleName() + "-" + this.rdCount);
        }
        dThread.setParentObjectPool(this.myParentPool);
        AspirinInternal.getConfiguration().getLogger().trace("GenericPoolableDeliveryThreadFactory.makeObject(): New DeliveryThread object created: {}.", (Object)dThread.getName());
        return dThread;
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof DeliveryThread) {
            DeliveryThread dThread = (DeliveryThread)obj;
            AspirinInternal.getConfiguration().getLogger().trace(((Object)((Object)this)).getClass().getSimpleName() + ".destroyObject(): destroy thread {}.", (Object)dThread.getName());
            dThread.shutdown();
        }
    }

    public boolean validateObject(Object obj) {
        if (obj instanceof DeliveryThread) {
            DeliveryThread dThread = (DeliveryThread)obj;
            return dThread.isAlive() && (dThread.getState().equals((Object)Thread.State.NEW) || dThread.getState().equals((Object)Thread.State.RUNNABLE) || dThread.getState().equals((Object)Thread.State.TIMED_WAITING) || dThread.getState().equals((Object)Thread.State.WAITING));
        }
        return false;
    }
}

