/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.dns;

import java.util.Collection;
import javax.mail.URLName;
import org.masukomi.aspirin.AspirinInternal;
import org.masukomi.aspirin.delivery.DeliveryContext;
import org.masukomi.aspirin.delivery.DeliveryException;
import org.masukomi.aspirin.delivery.DeliveryHandler;
import org.masukomi.aspirin.dns.DnsResolver;

public class ResolveHost
implements DeliveryHandler {
    @Override
    public void handle(DeliveryContext dCtx) throws DeliveryException {
        String currentRecipient = dCtx.getQueueInfo().getRecipient();
        String host = currentRecipient.substring(currentRecipient.lastIndexOf("@") + 1);
        Collection<URLName> targetServers = null;
        try {
            targetServers = DnsResolver.getMXRecordsForHost(host);
            if (targetServers == null || targetServers.size() == 0) {
                AspirinInternal.getLogger().warn("ResolveHost.handle(): No mail server found for: '{}'.", new Object[]{host});
                throw new DeliveryException("No MX record found. Temporary failure, trying again.", false);
            }
            AspirinInternal.getLogger().trace("ResolveHost.handle(): {} servers found for '{}'.", new Object[]{targetServers.size(), host});
            dCtx.addContextVariable("targetservers", targetServers);
        }
        catch (DeliveryException de) {
            throw de;
        }
        catch (Exception e) {
            AspirinInternal.getLogger().error("ResolveHost.handle(): Could not get MX for host '" + host + "' defined by recipient '" + currentRecipient + "'.", (Throwable)e);
            throw new DeliveryException("No MX record found. Temporary failure, trying again.", false);
        }
    }
}

