/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.masukomi.aspirin.AspirinInternal;
import org.masukomi.aspirin.listener.AspirinListener;
import org.masukomi.aspirin.listener.ResultState;
import org.masukomi.aspirin.store.queue.DeliveryState;
import org.masukomi.aspirin.store.queue.QueueInfo;

public class ListenerManager {
    private List<AspirinListener> listenerList = new ArrayList<AspirinListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AspirinListener listener) {
        List<AspirinListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AspirinListener listener) {
        List<AspirinListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(QueueInfo qi) {
        List<AspirinListener> listeners = null;
        List<AspirinListener> list = this.listenerList;
        synchronized (list) {
            listeners = Collections.unmodifiableList(this.listenerList);
        }
        if (listeners != null && !listeners.isEmpty()) {
            for (AspirinListener listener : listeners) {
                if (qi.hasState(DeliveryState.FAILED)) {
                    listener.delivered(qi.getMailid(), qi.getRecipient(), ResultState.FAILED, qi.getResultInfo());
                } else if (qi.hasState(DeliveryState.SENT)) {
                    listener.delivered(qi.getMailid(), qi.getRecipient(), ResultState.SENT, qi.getResultInfo());
                }
                if (!AspirinInternal.getDeliveryManager().isCompleted(qi)) continue;
                listener.delivered(qi.getMailid(), qi.getRecipient(), ResultState.FINISHED, qi.getResultInfo());
            }
        }
    }
}

