/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.store.queue;

import org.masukomi.aspirin.AspirinInternal;
import org.masukomi.aspirin.store.queue.DeliveryState;

public class QueueInfo {
    private String mailid;
    private String recipient;
    private String resultInfo;
    private long attempt = 0L;
    private int attemptCount = 0;
    private long expiry = -1L;
    private DeliveryState state = DeliveryState.QUEUED;
    private transient boolean notifiedAlready = false;
    private transient String complexId = null;
    private transient String qiToString = null;

    public String getComplexId() {
        if (this.complexId == null) {
            this.complexId = this.mailid + "-" + this.recipient;
        }
        return this.complexId;
    }

    public String getMailid() {
        return this.mailid;
    }

    public void setMailid(String mailid) {
        this.mailid = mailid;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getResultInfo() {
        return this.resultInfo;
    }

    public void setResultInfo(String resultInfo) {
        this.resultInfo = resultInfo;
    }

    public long getAttempt() {
        return this.attempt;
    }

    public void setAttempt(long attempt) {
        this.attempt = attempt;
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public void incAttemptCount() {
        ++this.attemptCount;
    }

    public void setAttemptCount(int attemptCount) {
        this.attemptCount = attemptCount;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    public DeliveryState getState() {
        return this.state;
    }

    public void setState(DeliveryState state) {
        this.state = state;
        if (AspirinInternal.getListenerManager() != null && !this.notifiedAlready && !this.hasState(DeliveryState.QUEUED, DeliveryState.IN_PROGRESS)) {
            AspirinInternal.getListenerManager().notifyListeners(this);
            this.notifiedAlready = true;
        }
    }

    public boolean hasState(DeliveryState ... states) {
        for (DeliveryState st : states) {
            if (!st.equals((Object)this.state)) continue;
            return true;
        }
        return false;
    }

    public boolean isSendable() {
        return this.hasState(DeliveryState.QUEUED) && this.getAttempt() < System.currentTimeMillis();
    }

    public boolean isInTimeBounds() {
        return (this.getExpiry() == -1L || System.currentTimeMillis() < this.getExpiry()) && this.getAttemptCount() < AspirinInternal.getConfiguration().getDeliveryAttemptCount();
    }

    public String toString() {
        if (this.qiToString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Mail: [id=").append(this.mailid).append("; recipient=").append(this.recipient).append("];");
            this.qiToString = sb.toString();
        }
        return this.qiToString;
    }
}

