/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.store.queue;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.masukomi.aspirin.Aspirin;
import org.masukomi.aspirin.AspirinInternal;
import org.masukomi.aspirin.store.queue.DeliveryState;
import org.masukomi.aspirin.store.queue.QueueInfo;
import org.masukomi.aspirin.store.queue.QueueStore;

public class SqliteQueueStore
implements QueueStore {
    public static final String PARAM_STORE_SQLITE_DB = "aspirin.store.sqlite.db";
    private Connection conn;

    public SqliteQueueStore() throws Exception {
        String sqliteDbPath = (String)Aspirin.getConfiguration().getProperty(PARAM_STORE_SQLITE_DB);
        if (sqliteDbPath == null) {
            throw new Exception("Store file is undefined. Please, check configuration.");
        }
        Class.forName("org.sqlite.JDBC");
        this.conn = DriverManager.getConnection("jdbc:sqlite:" + sqliteDbPath);
        this.conn.setAutoCommit(false);
        Statement stmt = this.conn.createStatement();
        stmt.execute("CREATE TABLE IF NOT EXISTS queueinfos (mailid VARCHAR(32), recipient TEXT, resultinfo TEXT, attempt BIGINT, attemptcount INT, expiry BIGINT, dstate SMALLINT)");
        stmt.execute("CREATE INDEX IF NOT EXISTS queueinfos_mailid_idx ON queueinfos (mailid)");
        stmt.execute("CREATE INDEX IF NOT EXISTS queueinfos_recipient_idx ON queueinfos (recipient)");
        stmt.execute("CREATE INDEX IF NOT EXISTS queueinfos_dstate_idx ON queueinfos (dstate)");
        stmt.execute("CREATE INDEX IF NOT EXISTS queueinfos_complexmr_idx ON queueinfos (mailid, recipient)");
        this.conn.commit();
        this.conn.setAutoCommit(true);
    }

    @Override
    public void add(String mailid, long expiry, Collection<InternetAddress> recipients) throws MessagingException {
        try {
            PreparedStatement pStmt = this.conn.prepareStatement("INSERT INTO queueinfos (mailid, recipient, resultinfo, attempt, attemptcount, expiry, dstate) VALUES (?,?,?,?,?,?,?)");
            for (InternetAddress recipient : recipients) {
                pStmt.setString(1, mailid);
                pStmt.setString(2, recipient.getAddress());
                pStmt.setNull(3, 2005);
                pStmt.setLong(4, System.currentTimeMillis());
                pStmt.setInt(5, 0);
                pStmt.setLong(6, expiry);
                pStmt.setInt(7, DeliveryState.QUEUED.getStateId());
                pStmt.addBatch();
            }
            int[] results = pStmt.executeBatch();
            boolean allOkay = true;
            for (int r : results) {
                if (r >= 0) continue;
                allOkay = false;
            }
            if (results.length != recipients.size() || !allOkay) {
                throw new MessagingException("Message queueing failed on prepared statement execution." + mailid);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Message queueing failed: " + mailid, e);
        }
    }

    @Override
    public List<String> clean() {
        ArrayList<String> usedMailIds = new ArrayList<String>();
        try {
            this.executeSimpleQuery("DELETE FROM queueinfos WHERE mailid NOT IN (SELECT mailid FROM queueinfos WHERE dstate IN (" + DeliveryState.QUEUED.getStateId() + ", " + DeliveryState.IN_PROGRESS.getStateId() + "))");
            Statement stmt = this.conn.createStatement();
            ResultSet rS = stmt.executeQuery("SELECT DISTINCT mailid FROM queueinfos");
            if (rS != null) {
                while (rS.next()) {
                    usedMailIds.add(rS.getString("mailid"));
                }
            }
            rS.close();
            this.executeSimpleQuery("VACUUM");
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("Store cleaning failed.", (Throwable)e);
        }
        return usedMailIds;
    }

    @Override
    public QueueInfo createQueueInfo() {
        return new QueueInfo();
    }

    @Override
    public long getNextAttempt(String mailid, String recipient) {
        try {
            Integer attempt;
            PreparedStatement pStmt = this.conn.prepareStatement("SELECT attempt FROM queueinfos WHERE mailid=? AND recipient=?");
            pStmt.setString(1, mailid);
            pStmt.setString(2, recipient);
            ResultSet rS = pStmt.executeQuery();
            if (rS != null && rS.next() && (attempt = Integer.valueOf(rS.getInt("attempt"))) != null && 0 < attempt) {
                return attempt.intValue();
            }
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("Next attempt checking failed.", (Throwable)e);
        }
        return 0L;
    }

    @Override
    public boolean hasBeenRecipientHandled(String mailid, String recipient) {
        try {
            PreparedStatement pStmt = this.conn.prepareStatement("SELECT dstate FROM queueinfos WHERE mailid=? AND recipient=?");
            pStmt.setString(1, mailid);
            pStmt.setString(2, recipient);
            ResultSet rS = pStmt.executeQuery();
            if (rS != null && rS.next()) {
                Integer dstate = rS.getInt("dstate");
                return dstate != null && (dstate.intValue() == DeliveryState.FAILED.getStateId() || dstate.intValue() == DeliveryState.SENT.getStateId());
            }
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("Concrete delivery status checking (mailid '" + mailid + "' + recipient '" + recipient + "') failed.", (Throwable)e);
        }
        return false;
    }

    @Override
    public void init() {
        try {
            this.executeSimpleQuery("UPDATE queueinfos SET dstate=" + DeliveryState.QUEUED.getStateId() + " WHERE dstate=" + DeliveryState.IN_PROGRESS.getStateId());
            AspirinInternal.getLogger().info("SQLite QueueStore initialized.");
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("SQLite QueueStore initialization failed.", (Throwable)e);
        }
    }

    @Override
    public boolean isCompleted(String mailid) {
        try {
            PreparedStatement pStmt = this.conn.prepareStatement("SELECT COUNT(recipient) AS recipientcount FROM queueinfos WHERE mailid=? AND (dstate=" + DeliveryState.QUEUED.getStateId() + " OR dstate=" + DeliveryState.IN_PROGRESS.getStateId() + ")");
            pStmt.setString(1, mailid);
            ResultSet rS = pStmt.executeQuery();
            if (rS != null && rS.next()) {
                Integer rCount = rS.getInt("recipientcount");
                return rCount != null && rCount == 0;
            }
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("Completion checking failed.", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueInfo next() {
        try {
            SqliteQueueStore sqliteQueueStore = this;
            synchronized (sqliteQueueStore) {
                PreparedStatement pStmt = this.conn.prepareStatement("SELECT mailid, recipient, attempt, attemptcount, expiry FROM queueinfos WHERE dstate=? ORDER BY attempt ASC LIMIT 100");
                pStmt.setInt(1, DeliveryState.QUEUED.getStateId());
                ResultSet rS = pStmt.executeQuery();
                if (rS != null) {
                    while (rS.next()) {
                        QueueInfo qi = new QueueInfo();
                        qi.setAttempt(rS.getLong("attempt"));
                        qi.setAttemptCount(rS.getInt("attemptcount"));
                        qi.setExpiry(rS.getLong("expiry"));
                        qi.setMailid(rS.getString("mailid"));
                        qi.setRecipient(rS.getString("recipient"));
                        qi.setState(DeliveryState.QUEUED);
                        if (!qi.isSendable()) continue;
                        if (!qi.isInTimeBounds()) {
                            qi.setResultInfo("Delivery is out of time or attempt.");
                            qi.setState(DeliveryState.FAILED);
                            this.setSendingResult(qi);
                            continue;
                        }
                        qi.setState(DeliveryState.IN_PROGRESS);
                        this.executeSimplePreparedStatement("UPDATE queueinfos SET dstate=? WHERE mailid=? AND recipient=?", DeliveryState.IN_PROGRESS.getStateId(), qi.getMailid(), qi.getRecipient());
                        return qi;
                    }
                }
            }
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("Failed get next sendable queueinfo item.", (Throwable)e);
        }
        return null;
    }

    @Override
    public void remove(String mailid) {
        try {
            this.executeSimplePreparedStatement("DELETE FROM queueinfos WHERE mailid=?", mailid);
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("Removing by mailid failed. mailid=" + mailid, (Throwable)e);
        }
    }

    @Override
    public void removeRecipient(String recipient) {
        try {
            this.executeSimplePreparedStatement("DELETE FROM queueinfos WHERE recipient=?", recipient);
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("Removing by recipient failed. recipient=" + recipient, (Throwable)e);
        }
    }

    @Override
    public void setSendingResult(QueueInfo qi) {
        try {
            this.executeSimplePreparedStatement("UPDATE queueinfos SET resultinfo=?, attempt=?, attemptcount=attemptcount+1, dstate=? WHERE mailid=? AND recipient=?", qi.getResultInfo(), System.currentTimeMillis() + (long)AspirinInternal.getConfiguration().getDeliveryAttemptDelay(), qi.getState().getStateId(), qi.getMailid(), qi.getRecipient());
            qi.setState(qi.getState());
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("Sending result set failed. qi=" + qi, (Throwable)e);
        }
    }

    @Override
    public int size() {
        try {
            Integer mcount;
            Statement stmt = this.conn.createStatement();
            ResultSet rS = stmt.executeQuery("SELECT COUNT(DISTINCT mailid) AS mcount FROM queueinfos");
            if (rS != null && rS.next() && (mcount = Integer.valueOf(rS.getInt("mcount"))) != null && 0 < mcount) {
                return mcount;
            }
        }
        catch (SQLException e) {
            AspirinInternal.getLogger().error("Calculating queue size failed.", (Throwable)e);
        }
        return 0;
    }

    private void executeSimpleQuery(String query) throws SQLException {
        Statement stmt = this.conn.createStatement();
        stmt.execute(query);
    }

    private void executeSimplePreparedStatement(String sql, Object ... parameters) throws SQLException {
        PreparedStatement pStmt = this.conn.prepareStatement(sql);
        int i = 1;
        for (Object parameter : parameters) {
            if (parameter instanceof String) {
                pStmt.setString(i, (String)parameter);
            } else if (parameter instanceof Integer) {
                pStmt.setInt(i, (Integer)parameter);
            } else if (parameter instanceof Long) {
                pStmt.setLong(i, (Long)parameter);
            }
            ++i;
        }
        pStmt.execute();
    }
}

