/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import com.mongodb.DBPointer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.types.ObjectId;

public class Bytes
extends BSON {
    static final Logger LOGGER = Logger.getLogger("com.mongodb");
    static final boolean D = Boolean.getBoolean("DEBUG.MONGO");
    public static final ByteOrder ORDER;
    static final int MAX_OBJECT_SIZE = 0x400000;
    static final int BATCH_INSERT_SIZE = 0x800000;
    static final int CONNECTIONS_PER_HOST;
    public static final int QUERYOPTION_TAILABLE = 2;
    public static final int QUERYOPTION_SLAVEOK = 4;
    public static final int QUERYOPTION_OPLOGREPLAY = 8;
    public static final int QUERYOPTION_NOTIMEOUT = 16;
    public static final int QUERYOPTION_AWAITDATA = 32;
    public static final int QUERYOPTION_EXHAUST = 64;
    public static final int RESULTFLAG_CURSORNOTFOUND = 1;
    public static final int RESULTFLAG_ERRSET = 2;
    public static final int RESULTFLAG_SHARDCONFIGSTALE = 4;
    public static final int RESULTFLAG_AWAITCAPABLE = 8;
    static final ObjectId COLLECTION_REF_ID;

    public static byte getType(Object o) {
        if (o == null) {
            return 10;
        }
        if (o instanceof DBPointer) {
            return 12;
        }
        if (o instanceof Number) {
            return 1;
        }
        if (o instanceof String) {
            return 2;
        }
        if (o instanceof List) {
            return 4;
        }
        if (o instanceof byte[]) {
            return 5;
        }
        if (o instanceof ObjectId) {
            return 7;
        }
        if (o instanceof Boolean) {
            return 8;
        }
        if (o instanceof Date) {
            return 9;
        }
        if (o instanceof Pattern) {
            return 11;
        }
        if (o instanceof DBObject) {
            return 3;
        }
        return 0;
    }

    static {
        if (LOGGER.getLevel() == null) {
            if (D) {
                LOGGER.setLevel(Level.ALL);
            } else {
                LOGGER.setLevel(Level.WARNING);
            }
        }
        ORDER = ByteOrder.LITTLE_ENDIAN;
        CONNECTIONS_PER_HOST = Integer.parseInt(System.getProperty("MONGO.POOLSIZE", "10"));
        COLLECTION_REF_ID = new ObjectId(-1, -1, -1);
    }

    static class OptionHolder {
        final OptionHolder _parent;
        int _options = 0;
        boolean _hasOptions = false;

        OptionHolder(OptionHolder parent) {
            this._parent = parent;
        }

        void set(int options) {
            this._options = options;
            this._hasOptions = true;
        }

        int get() {
            if (this._hasOptions) {
                return this._options;
            }
            if (this._parent == null) {
                return 0;
            }
            return this._parent.get();
        }

        void add(int option) {
            this.set(this.get() | option);
        }

        void reset() {
            this._hasOptions = false;
        }
    }
}

