/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.operation.AbortTransactionOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommitTransactionOperation;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.session.BaseClientSessionImpl;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.MongoClientImpl;
import com.mongodb.reactivestreams.client.internal.OperationExecutor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

final class ClientSessionPublisherImpl
extends BaseClientSessionImpl
implements ClientSession {
    private final MongoClientImpl mongoClient;
    private final OperationExecutor executor;
    private BaseClientSessionImpl.TransactionState transactionState = BaseClientSessionImpl.TransactionState.NONE;
    private boolean messageSentInCurrentTransaction;
    private boolean commitInProgress;
    private TransactionOptions transactionOptions;

    ClientSessionPublisherImpl(ServerSessionPool serverSessionPool, MongoClientImpl mongoClient, ClientSessionOptions options, OperationExecutor executor) {
        super(serverSessionPool, (Object)mongoClient, options);
        this.executor = executor;
        this.mongoClient = mongoClient;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.transactionState == BaseClientSessionImpl.TransactionState.IN || this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED && this.commitInProgress;
    }

    @Override
    public boolean notifyMessageSent() {
        if (this.hasActiveTransaction()) {
            boolean firstMessageInCurrentTransaction = !this.messageSentInCurrentTransaction;
            this.messageSentInCurrentTransaction = true;
            return firstMessageInCurrentTransaction;
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED || this.transactionState == BaseClientSessionImpl.TransactionState.ABORTED) {
            this.cleanupTransaction(BaseClientSessionImpl.TransactionState.NONE);
        }
        return false;
    }

    @Override
    public void notifyOperationInitiated(Object operation) {
        Assertions.assertTrue((operation instanceof AsyncReadOperation || operation instanceof AsyncWriteOperation ? 1 : 0) != 0);
        if (!this.hasActiveTransaction() && !(operation instanceof CommitTransactionOperation)) {
            Assertions.assertTrue((this.getPinnedServerAddress() == null || this.transactionState != BaseClientSessionImpl.TransactionState.ABORTED && this.transactionState != BaseClientSessionImpl.TransactionState.NONE ? 1 : 0) != 0);
            this.clearTransactionContext();
        }
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        Assertions.isTrue((String)"in transaction", (this.transactionState == BaseClientSessionImpl.TransactionState.IN || this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED ? 1 : 0) != 0);
        return this.transactionOptions;
    }

    @Override
    public void startTransaction() {
        this.startTransaction(TransactionOptions.builder().build());
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        Assertions.notNull((String)"transactionOptions", (Object)transactionOptions);
        Boolean snapshot = this.getOptions().isSnapshot();
        if (snapshot != null && snapshot.booleanValue()) {
            throw new IllegalArgumentException("Transactions are not supported in snapshot sessions");
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.IN) {
            throw new IllegalStateException("Transaction already in progress");
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED) {
            this.cleanupTransaction(BaseClientSessionImpl.TransactionState.IN);
        } else {
            this.transactionState = BaseClientSessionImpl.TransactionState.IN;
        }
        this.getServerSession().advanceTransactionNumber();
        this.transactionOptions = TransactionOptions.merge((TransactionOptions)transactionOptions, (TransactionOptions)this.getOptions().getDefaultTransactionOptions());
        TimeoutContext timeoutContext = this.createTimeoutContext();
        WriteConcern writeConcern = this.getWriteConcern(timeoutContext);
        if (writeConcern == null) {
            throw new MongoInternalException("Invariant violated. Transaction options write concern can not be null");
        }
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Transactions do not support unacknowledged write concern");
        }
        this.clearTransactionContext();
        this.setTimeoutContext(timeoutContext);
    }

    @Nullable
    private WriteConcern getWriteConcern(@Nullable TimeoutContext timeoutContext) {
        WriteConcern writeConcern = this.transactionOptions.getWriteConcern();
        if (ClientSessionPublisherImpl.hasTimeoutMS((TimeoutContext)timeoutContext) && ClientSessionPublisherImpl.hasWTimeoutMS((WriteConcern)writeConcern)) {
            return WriteConcernHelper.cloneWithoutTimeout((WriteConcern)writeConcern);
        }
        return writeConcern;
    }

    @Override
    public Publisher<Void> commitTransaction() {
        if (this.transactionState == BaseClientSessionImpl.TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call commitTransaction after calling abortTransaction");
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSentInCurrentTransaction) {
            this.cleanupTransaction(BaseClientSessionImpl.TransactionState.COMMITTED);
            return Mono.create(MonoSink::success);
        }
        ReadConcern readConcern = this.transactionOptions.getReadConcern();
        if (readConcern == null) {
            throw new MongoInternalException("Invariant violated. Transaction options read concern can not be null");
        }
        boolean alreadyCommitted = this.commitInProgress || this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED;
        this.commitInProgress = true;
        this.resetTimeout();
        TimeoutContext timeoutContext = this.getTimeoutContext();
        WriteConcern writeConcern = (WriteConcern)Assertions.assertNotNull((Object)this.getWriteConcern(timeoutContext));
        return this.executor.execute(new CommitTransactionOperation(writeConcern, alreadyCommitted).recoveryToken(this.getRecoveryToken()), readConcern, this).doOnTerminate(() -> {
            this.commitInProgress = false;
            this.transactionState = BaseClientSessionImpl.TransactionState.COMMITTED;
        }).doOnError(MongoException.class, this::clearTransactionContextOnError);
    }

    @Override
    public Publisher<Void> abortTransaction() {
        if (this.transactionState == BaseClientSessionImpl.TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call abortTransaction twice");
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED) {
            throw new IllegalStateException("Cannot call abortTransaction after calling commitTransaction");
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSentInCurrentTransaction) {
            this.cleanupTransaction(BaseClientSessionImpl.TransactionState.ABORTED);
            return Mono.create(MonoSink::success);
        }
        ReadConcern readConcern = this.transactionOptions.getReadConcern();
        if (readConcern == null) {
            throw new MongoInternalException("Invariant violated. Transaction options read concern can not be null");
        }
        this.resetTimeout();
        TimeoutContext timeoutContext = this.getTimeoutContext();
        WriteConcern writeConcern = (WriteConcern)Assertions.assertNotNull((Object)this.getWriteConcern(timeoutContext));
        return this.executor.execute(new AbortTransactionOperation(writeConcern).recoveryToken(this.getRecoveryToken()), readConcern, this).onErrorResume(Throwable.class, e -> Mono.empty()).doOnTerminate(() -> {
            this.clearTransactionContext();
            this.cleanupTransaction(BaseClientSessionImpl.TransactionState.ABORTED);
        });
    }

    private void clearTransactionContextOnError(MongoException e) {
        if (e.hasErrorLabel("TransientTransactionError") || e.hasErrorLabel("UnknownTransactionCommitResult")) {
            this.clearTransactionContext();
        }
    }

    public void close() {
        if (this.transactionState == BaseClientSessionImpl.TransactionState.IN) {
            Mono.from(this.abortTransaction()).doFinally(it -> super.close()).subscribe();
        } else {
            super.close();
        }
    }

    private void cleanupTransaction(BaseClientSessionImpl.TransactionState nextState) {
        this.messageSentInCurrentTransaction = false;
        this.transactionOptions = null;
        this.transactionState = nextState;
        this.setTimeoutContext(null);
    }

    private TimeoutContext createTimeoutContext() {
        return new TimeoutContext(this.getTimeoutSettings(this.transactionOptions, this.executor.getTimeoutSettings()));
    }
}

