/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.reader.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.canova.api.conf.Configuration;
import org.canova.api.records.reader.RecordReader;
import org.canova.api.split.InputSplit;
import org.canova.api.writable.Writable;

public class ComposableRecordReader
implements RecordReader {
    private RecordReader[] readers;

    public ComposableRecordReader(RecordReader ... readers) {
        this.readers = readers;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public Collection<Writable> next() {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        if (this.hasNext()) {
            for (RecordReader reader : this.readers) {
                ret.addAll(reader.next());
            }
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        Boolean readersHasNext = true;
        for (RecordReader reader : this.readers) {
            readersHasNext = readersHasNext != false && reader.hasNext();
        }
        return readersHasNext;
    }

    @Override
    public void close() throws IOException {
        for (RecordReader reader : this.readers) {
            reader.close();
        }
    }

    @Override
    public void setConf(Configuration conf) {
    }

    @Override
    public Configuration getConf() {
        return null;
    }
}

