/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.reader.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.canova.api.conf.Configuration;
import org.canova.api.io.data.Text;
import org.canova.api.records.reader.RecordReader;
import org.canova.api.split.InputSplit;
import org.canova.api.writable.Writable;

public class FileRecordReader
implements RecordReader {
    protected Iterator<File> iter;
    protected Configuration conf;
    protected File currentFile;
    protected List<String> labels;
    protected boolean appendLabel = false;

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.doInitialize(split);
    }

    protected void doInitialize(InputSplit split) {
        URI[] locations = split.locations();
        if (locations != null && locations.length >= 1) {
            if (locations.length > 1) {
                ArrayList allFiles = new ArrayList();
                for (URI location : locations) {
                    File iter = new File(location);
                    if (this.labels == null && this.appendLabel) {
                        File parent = iter.getParentFile().getParentFile();
                        this.labels = new ArrayList<String>();
                        for (File labelDir : parent.listFiles()) {
                            this.labels.add(labelDir.getName());
                        }
                    }
                    if (iter.isDirectory()) {
                        Iterator allFiles2 = FileUtils.iterateFiles((File)iter, null, (boolean)true);
                        while (allFiles2.hasNext()) {
                            allFiles.add(allFiles2.next());
                        }
                        continue;
                    }
                    allFiles.add(iter);
                }
                this.iter = allFiles.iterator();
            } else {
                File curr = new File(locations[0]);
                this.iter = curr.isDirectory() ? FileUtils.iterateFiles((File)curr, null, (boolean)true) : Collections.singletonList(curr).iterator();
            }
        }
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.appendLabel = conf.getBoolean(APPEND_LABEL, true);
        this.doInitialize(split);
    }

    @Override
    public Collection<Writable> next() {
        File next;
        ArrayList<Writable> ret = new ArrayList<Writable>();
        try {
            this.currentFile = next = this.iter.next();
            ret.add(new Text(FileUtils.readFileToString((File)next)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.iter.hasNext()) {
            return ret;
        }
        if (this.iter.hasNext()) {
            try {
                this.currentFile = next = this.iter.next();
                ret.add(new Text(FileUtils.readFileToString((File)next)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected int getCurrentLabel() {
        return this.labels.indexOf(this.currentFile.getParentFile().getName());
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Override
    public boolean hasNext() {
        return this.iter != null && this.iter.hasNext();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

