/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.reader.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.canova.api.conf.Configuration;
import org.canova.api.io.data.Text;
import org.canova.api.records.reader.RecordReader;
import org.canova.api.split.InputSplit;
import org.canova.api.split.StringSplit;
import org.canova.api.writable.Writable;

public class LineRecordReader
implements RecordReader {
    private URI[] locations;
    private int currIndex = 0;
    private Iterator<String> iter;
    protected Configuration conf;

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        if (split instanceof StringSplit) {
            StringSplit stringSplit = (StringSplit)split;
            this.iter = Arrays.asList(stringSplit.getData()).iterator();
        } else {
            this.locations = split.locations();
            if (this.locations != null && this.locations.length > 0) {
                this.iter = IOUtils.lineIterator((Reader)new InputStreamReader(this.locations[0].toURL().openStream()));
            }
        }
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.initialize(split);
    }

    @Override
    public Collection<Writable> next() {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        if (this.iter.hasNext()) {
            ret.add(new Text(this.iter.next()));
            return ret;
        }
        ++this.currIndex;
        try {
            this.close();
            this.iter = IOUtils.lineIterator((Reader)new InputStreamReader(this.locations[this.currIndex].toURL().openStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.iter.hasNext()) {
            ret.add(new Text(this.iter.next()));
            return ret;
        }
        throw new NoSuchElementException("No more elements found!");
    }

    @Override
    public boolean hasNext() {
        return this.iter != null && this.iter.hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.iter != null && this.iter instanceof LineIterator) {
            LineIterator iter2 = (LineIterator)this.iter;
            iter2.close();
        }
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

