/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.writer.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import org.canova.api.conf.Configuration;
import org.canova.api.records.writer.impl.FileRecordWriter;
import org.canova.api.writable.Writable;

public class CSVRecordWriter
extends FileRecordWriter {
    public CSVRecordWriter() {
    }

    public CSVRecordWriter(File path) throws FileNotFoundException {
        super(path);
    }

    public CSVRecordWriter(File path, boolean append) throws FileNotFoundException {
        super(path, append);
    }

    public CSVRecordWriter(Configuration conf) throws FileNotFoundException {
        super(conf);
    }

    @Override
    public void write(Collection<Writable> record) throws IOException {
        if (!record.isEmpty()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (Writable w : record) {
                w.write(dos);
                dos.write("\n".getBytes());
            }
            dos.flush();
            dos.close();
        }
    }
}

