/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.writer.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.canova.api.conf.Configuration;
import org.canova.api.records.reader.LibSvm;
import org.canova.api.records.writer.impl.LineRecordWriter;
import org.canova.api.writable.Writable;

public class LibSvmRecordWriter
extends LineRecordWriter
implements LibSvm {
    public LibSvmRecordWriter(File path) throws FileNotFoundException {
        super(path);
    }

    public LibSvmRecordWriter(File path, boolean append) throws FileNotFoundException {
        super(path, append);
    }

    public LibSvmRecordWriter(Configuration conf) throws FileNotFoundException {
        super(conf);
    }

    public LibSvmRecordWriter() {
    }

    @Override
    public void write(Collection<Writable> record) throws IOException {
        List<Object> asList = record instanceof List ? (List<Object>)record : new ArrayList<Writable>(record);
        double response = Double.valueOf(((Writable)asList.get(asList.size() - 1)).toString());
        StringBuffer write = new StringBuffer();
        boolean classification = this.conf.getBoolean("libsvm.classification", true);
        if (classification) {
            write.append((int)response);
        } else {
            write.append(response);
        }
        write.append(" ");
        for (int i = 0; i < asList.size() - 1; ++i) {
            double val = Double.valueOf(((Writable)asList.get(i)).toString());
            if (val == 0.0) continue;
            try {
                write.append(i + 1 + ":" + Integer.valueOf(((Writable)asList.get(i)).toString()));
            }
            catch (NumberFormatException e) {
                write.append(i + 1 + ":" + Double.valueOf(((Writable)asList.get(i)).toString()));
            }
            if (i >= asList.size() - 1) continue;
            write.append(" ");
        }
        this.out.write(write.toString().trim().getBytes());
        this.out.write("\n".getBytes());
    }
}

